/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.jmx.MBean;
import org.elasticsearch.jmx.ManagedAttribute;

@MBean(objectName="shardType=store", description="The storage of the index shard")
public class StoreManagement
extends AbstractIndexShardComponent {
    private final Store store;

    @Inject
    public StoreManagement(Store store) {
        super(store.shardId(), store.indexSettings());
        this.store = store;
    }

    @ManagedAttribute(description="Size in bytes")
    public long getSizeInBytes() {
        try {
            return this.store.estimateSize().bytes();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @ManagedAttribute(description="Size")
    public String getSize() {
        try {
            return this.store.estimateSize().toString();
        }
        catch (IOException e) {
            return "NA";
        }
    }
}

