/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNameModule;
import org.elasticsearch.index.IndexServiceManagement;
import org.elasticsearch.index.LocalNodeIdModule;
import org.elasticsearch.index.aliases.IndexAliasesServiceModule;
import org.elasticsearch.index.analysis.AnalysisModule;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.CacheStats;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.IndexCacheModule;
import org.elasticsearch.index.engine.IndexEngine;
import org.elasticsearch.index.engine.IndexEngineModule;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.gateway.IndexGateway;
import org.elasticsearch.index.gateway.IndexGatewayModule;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceModule;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.percolator.PercolatorModule;
import org.elasticsearch.index.percolator.PercolatorService;
import org.elasticsearch.index.query.IndexQueryParserModule;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.service.InternalIndexService;
import org.elasticsearch.index.settings.IndexSettingsModule;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.similarity.SimilarityModule;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.IndexStoreModule;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.plugins.IndexPluginsModule;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalIndicesService
extends AbstractLifecycleComponent<IndicesService>
implements IndicesService {
    private final NodeEnvironment nodeEnv;
    private final ThreadPool threadPool;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final IndicesAnalysisService indicesAnalysisService;
    private final IndicesStore indicesStore;
    private final Injector injector;
    private final PluginsService pluginsService;
    private final Map<String, Injector> indicesInjectors = new HashMap<String, Injector>();
    private volatile ImmutableMap<String, IndexService> indices = ImmutableMap.of();
    private final OldShardsStats oldShardsStats = new OldShardsStats();

    @Inject
    public InternalIndicesService(Settings settings, NodeEnvironment nodeEnv, ThreadPool threadPool, IndicesLifecycle indicesLifecycle, IndicesAnalysisService indicesAnalysisService, IndicesStore indicesStore, Injector injector) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.threadPool = threadPool;
        this.indicesLifecycle = (InternalIndicesLifecycle)indicesLifecycle;
        this.indicesAnalysisService = indicesAnalysisService;
        this.indicesStore = indicesStore;
        this.injector = injector;
        this.pluginsService = injector.getInstance(PluginsService.class);
        this.indicesLifecycle.addListener(this.oldShardsStats);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() throws ElasticSearchException {
        ImmutableSet<String> indices = ImmutableSet.copyOf(this.indices.keySet());
        final CountDownLatch latch = new CountDownLatch(indices.size());
        ExecutorService indicesStopExecutor = Executors.newFixedThreadPool(5, EsExecutors.daemonThreadFactory("indices_shutdown"));
        final ExecutorService shardsStopExecutor = Executors.newFixedThreadPool(5, EsExecutors.daemonThreadFactory("shards_shutdown"));
        for (final String index : indices) {
            indicesStopExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        InternalIndicesService.this.deleteIndex(index, false, "shutdown", shardsStopExecutor);
                    }
                    catch (Exception e) {
                        InternalIndicesService.this.logger.warn("failed to delete index on stop [" + index + "]", e, new Object[0]);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
        }
        finally {
            shardsStopExecutor.shutdown();
            indicesStopExecutor.shutdown();
        }
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.injector.getInstance(RecoverySettings.class).close();
        this.indicesStore.close();
        this.indicesAnalysisService.close();
    }

    @Override
    public IndicesLifecycle indicesLifecycle() {
        return this.indicesLifecycle;
    }

    @Override
    public NodeIndicesStats stats(boolean includePrevious) {
        DocsStats docsStats = new DocsStats();
        StoreStats storeStats = new StoreStats();
        IndexingStats indexingStats = new IndexingStats();
        GetStats getStats = new GetStats();
        SearchStats searchStats = new SearchStats();
        CacheStats cacheStats = new CacheStats();
        MergeStats mergeStats = new MergeStats();
        RefreshStats refreshStats = new RefreshStats();
        FlushStats flushStats = new FlushStats();
        if (includePrevious) {
            getStats.add(this.oldShardsStats.getStats);
            indexingStats.add(this.oldShardsStats.indexingStats);
            searchStats.add(this.oldShardsStats.searchStats);
            mergeStats.add(this.oldShardsStats.mergeStats);
            refreshStats.add(this.oldShardsStats.refreshStats);
            flushStats.add(this.oldShardsStats.flushStats);
        }
        for (IndexService indexService : this.indices.values()) {
            for (IndexShard indexShard : indexService) {
                storeStats.add(indexShard.storeStats());
                docsStats.add(indexShard.docStats());
                getStats.add(indexShard.getStats());
                indexingStats.add(indexShard.indexingStats(new String[0]));
                searchStats.add(indexShard.searchStats(new String[0]));
                mergeStats.add(indexShard.mergeStats());
                refreshStats.add(indexShard.refreshStats());
                flushStats.add(indexShard.flushStats());
            }
            cacheStats.add(indexService.cache().stats());
        }
        return new NodeIndicesStats(storeStats, docsStats, indexingStats, getStats, searchStats, cacheStats, mergeStats, refreshStats, flushStats);
    }

    @Override
    public boolean changesAllowed() {
        return this.lifecycle.started();
    }

    @Override
    public UnmodifiableIterator<IndexService> iterator() {
        return ((ImmutableCollection)this.indices.values()).iterator();
    }

    @Override
    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    @Override
    public Set<String> indices() {
        return Sets.newHashSet(this.indices.keySet());
    }

    @Override
    public IndexService indexService(String index) {
        return this.indices.get(index);
    }

    @Override
    public IndexService indexServiceSafe(String index) throws IndexMissingException {
        IndexService indexService = this.indexService(index);
        if (indexService == null) {
            throw new IndexMissingException(new Index(index));
        }
        return indexService;
    }

    @Override
    public synchronized IndexService createIndex(String sIndexName, Settings settings, String localNodeId) throws ElasticSearchException {
        Injector indexInjector;
        if (!this.lifecycle.started()) {
            throw new ElasticSearchIllegalStateException("Can't create an index [" + sIndexName + "], node is closed");
        }
        Index index = new Index(sIndexName);
        if (this.indicesInjectors.containsKey(index.name())) {
            throw new IndexAlreadyExistsException(index);
        }
        this.indicesLifecycle.beforeIndexCreated(index);
        this.logger.debug("creating Index [{}], shards [{}]/[{}]", sIndexName, settings.get("index.number_of_shards"), settings.get("index.number_of_replicas"));
        Settings indexSettings = ImmutableSettings.settingsBuilder().put(this.settings).put(settings).classLoader(settings.getClassLoader()).build();
        ModulesBuilder modules = new ModulesBuilder();
        modules.add((Module)new IndexNameModule(index));
        modules.add((Module)new LocalNodeIdModule(localNodeId));
        modules.add((Module)new IndexSettingsModule(index, indexSettings));
        modules.add((Module)new IndexPluginsModule(indexSettings, this.pluginsService));
        modules.add((Module)new IndexStoreModule(indexSettings));
        modules.add((Module)new IndexEngineModule(indexSettings));
        modules.add((Module)new AnalysisModule(indexSettings, this.indicesAnalysisService));
        modules.add((Module)new SimilarityModule(indexSettings));
        modules.add((Module)new IndexCacheModule(indexSettings));
        modules.add((Module)new IndexQueryParserModule(indexSettings));
        modules.add((Module)new MapperServiceModule());
        modules.add((Module)new IndexAliasesServiceModule());
        modules.add((Module)new IndexGatewayModule(indexSettings, this.injector.getInstance(Gateway.class)));
        modules.add((Module)new IndexModule(indexSettings));
        modules.add((Module)new PercolatorModule());
        try {
            indexInjector = modules.createChildInjector(this.injector);
        }
        catch (CreationException e) {
            throw new IndexCreationException(index, Injectors.getFirstErrorFailure(e));
        }
        catch (Throwable e) {
            throw new IndexCreationException(index, e);
        }
        this.indicesInjectors.put(index.name(), indexInjector);
        IndexService indexService = indexInjector.getInstance(IndexService.class);
        this.indicesLifecycle.afterIndexCreated(indexService);
        this.indices = MapBuilder.newMapBuilder(this.indices).put(index.name(), indexService).immutableMap();
        return indexService;
    }

    @Override
    public synchronized void cleanIndex(String index, String reason) throws ElasticSearchException {
        this.deleteIndex(index, false, reason, null);
    }

    @Override
    public synchronized void deleteIndex(String index, String reason) throws ElasticSearchException {
        this.deleteIndex(index, true, reason, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIndex(String index, boolean delete, String reason, @Nullable Executor executor) throws ElasticSearchException {
        IndexService indexService;
        Injector indexInjector;
        InternalIndicesService internalIndicesService = this;
        synchronized (internalIndicesService) {
            indexInjector = this.indicesInjectors.remove(index);
            if (indexInjector == null) {
                if (!delete) {
                    return;
                }
                throw new IndexMissingException(new Index(index));
            }
            if (delete) {
                this.logger.debug("deleting Index [{}]", index);
            }
            HashMap<String, IndexService> tmpMap = Maps.newHashMap(this.indices);
            indexService = (IndexService)tmpMap.remove(index);
            this.indices = ImmutableMap.copyOf(tmpMap);
        }
        this.indicesLifecycle.beforeIndexClosed(indexService, delete);
        for (Class<? extends CloseableIndexComponent> closeable : this.pluginsService.indexServices()) {
            indexInjector.getInstance(closeable).close(delete);
        }
        ((InternalIndexService)indexService).close(delete, reason, executor);
        indexInjector.getInstance(PercolatorService.class).close();
        indexInjector.getInstance(IndexCache.class).close();
        indexInjector.getInstance(AnalysisService.class).close();
        indexInjector.getInstance(IndexEngine.class).close();
        indexInjector.getInstance(IndexServiceManagement.class).close();
        indexInjector.getInstance(IndexGateway.class).close(delete);
        indexInjector.getInstance(MapperService.class).close();
        indexInjector.getInstance(IndexQueryParserService.class).close();
        indexInjector.getInstance(IndexStore.class).close(delete);
        Injectors.close(this.injector);
        this.indicesLifecycle.afterIndexClosed(indexService.index(), delete);
        if (delete) {
            FileSystemUtils.deleteRecursively(this.nodeEnv.indexLocations(new Index(index)));
        }
    }

    static class OldShardsStats
    extends IndicesLifecycle.Listener {
        final SearchStats searchStats = new SearchStats();
        final GetStats getStats = new GetStats();
        final IndexingStats indexingStats = new IndexingStats();
        final MergeStats mergeStats = new MergeStats();
        final RefreshStats refreshStats = new RefreshStats();
        final FlushStats flushStats = new FlushStats();

        OldShardsStats() {
        }

        @Override
        public synchronized void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, boolean delete) {
            if (indexShard != null) {
                this.getStats.add(indexShard.getStats());
                this.indexingStats.add(indexShard.indexingStats(new String[0]), false);
                this.searchStats.add(indexShard.searchStats(new String[0]), false);
                this.mergeStats.add(indexShard.mergeStats());
                this.refreshStats.add(indexShard.refreshStats());
                this.flushStats.add(indexShard.flushStats());
            }
        }
    }
}

