/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.shard.ShardId;

class RecoveryFilesInfoRequest
implements Streamable {
    ShardId shardId;
    List<String> phase1FileNames;
    List<Long> phase1FileSizes;
    List<String> phase1ExistingFileNames;
    List<Long> phase1ExistingFileSizes;
    long phase1TotalSize;
    long phase1ExistingTotalSize;

    RecoveryFilesInfoRequest() {
    }

    RecoveryFilesInfoRequest(ShardId shardId, List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, long phase1TotalSize, long phase1ExistingTotalSize) {
        this.shardId = shardId;
        this.phase1FileNames = phase1FileNames;
        this.phase1FileSizes = phase1FileSizes;
        this.phase1ExistingFileNames = phase1ExistingFileNames;
        this.phase1ExistingFileSizes = phase1ExistingFileSizes;
        this.phase1TotalSize = phase1TotalSize;
        this.phase1ExistingTotalSize = phase1ExistingTotalSize;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        this.shardId = ShardId.readShardId(in);
        int size = in.readVInt();
        this.phase1FileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileNames.add(in.readUTF());
        }
        size = in.readVInt();
        this.phase1FileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1FileSizes.add(in.readVLong());
        }
        size = in.readVInt();
        this.phase1ExistingFileNames = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileNames.add(in.readUTF());
        }
        size = in.readVInt();
        this.phase1ExistingFileSizes = new ArrayList<Long>(size);
        for (i = 0; i < size; ++i) {
            this.phase1ExistingFileSizes.add(in.readVLong());
        }
        this.phase1TotalSize = in.readVLong();
        this.phase1ExistingTotalSize = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        out.writeVInt(this.phase1FileNames.size());
        for (String phase1FileName : this.phase1FileNames) {
            out.writeUTF(phase1FileName);
        }
        out.writeVInt(this.phase1FileSizes.size());
        for (Long phase1FileSize : this.phase1FileSizes) {
            out.writeVLong(phase1FileSize);
        }
        out.writeVInt(this.phase1ExistingFileNames.size());
        for (String phase1ExistingFileName : this.phase1ExistingFileNames) {
            out.writeUTF(phase1ExistingFileName);
        }
        out.writeVInt(this.phase1ExistingFileSizes.size());
        for (Long phase1ExistingFileSize : this.phase1ExistingFileSizes) {
            out.writeVLong(phase1ExistingFileSize);
        }
        out.writeVLong(this.phase1TotalSize);
        out.writeVLong(this.phase1ExistingTotalSize);
    }
}

