/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.store;

import java.io.File;
import org.apache.lucene.store.StoreRateLimiting;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesStore
extends AbstractComponent
implements ClusterStateListener {
    private final NodeEnvironment nodeEnv;
    private final NodeSettingsService nodeSettingsService;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private volatile String rateLimitingType;
    private volatile ByteSizeValue rateLimitingThrottle;
    private final StoreRateLimiting rateLimiting = new StoreRateLimiting();
    private final ApplySettings applySettings = new ApplySettings();

    @Inject
    public IndicesStore(Settings settings, NodeEnvironment nodeEnv, NodeSettingsService nodeSettingsService, IndicesService indicesService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.nodeSettingsService = nodeSettingsService;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.rateLimitingType = this.componentSettings.get("throttle.type", "none");
        this.rateLimiting.setType(this.rateLimitingType);
        this.rateLimitingThrottle = this.componentSettings.getAsBytesSize("throttle.max_bytes_per_sec", new ByteSizeValue(0L));
        this.rateLimiting.setMaxRate(this.rateLimitingThrottle);
        this.logger.debug("using indices.store.throttle.type [{}], with index.store.throttle.max_bytes_per_sec [{}]", this.rateLimitingType, this.rateLimitingThrottle);
        nodeSettingsService.addListener(this.applySettings);
        clusterService.addLast(this);
    }

    public StoreRateLimiting rateLimiting() {
        return this.rateLimiting;
    }

    public void close() {
        this.nodeSettingsService.removeListener(this.applySettings);
        this.clusterService.remove(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        IndexService indexService;
        if (!event.routingTableChanged()) {
            return;
        }
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        RoutingTable routingTable = event.state().routingTable();
        for (IndexRoutingTable indexRoutingTable : routingTable) {
            indexService = this.indicesService.indexService(indexRoutingTable.index());
            if (indexService == null || !indexService.store().persistent()) continue;
            for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                int startedShardsCount;
                if (indexService.hasShard(indexShardRoutingTable.shardId().id()) || !indexService.store().canDeleteUnallocated(indexShardRoutingTable.shardId()) || (startedShardsCount = indexShardRoutingTable.countWithState(ShardRoutingState.STARTED)) <= 0 || startedShardsCount != indexShardRoutingTable.size()) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("[{}][{}] deleting unallocated shard", indexShardRoutingTable.shardId().index().name(), indexShardRoutingTable.shardId().id());
                }
                try {
                    indexService.store().deleteUnallocated(indexShardRoutingTable.shardId());
                }
                catch (Exception e) {
                    this.logger.debug("[{}][{}] failed to delete unallocated shard, ignoring", e, indexShardRoutingTable.shardId().index().name(), indexShardRoutingTable.shardId().id());
                }
            }
        }
        if (this.nodeEnv.hasNodeFile()) {
            for (IndexRoutingTable indexRoutingTable : routingTable) {
                indexService = this.indicesService.indexService(indexRoutingTable.index());
                if (indexService != null) continue;
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    boolean shardCanBeDeleted = true;
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        if (!shardRouting.active()) {
                            shardCanBeDeleted = false;
                            break;
                        }
                        String localNodeId = this.clusterService.localNode().id();
                        if (!localNodeId.equals(shardRouting.currentNodeId()) && !localNodeId.equals(shardRouting.relocatingNodeId())) continue;
                        shardCanBeDeleted = false;
                        break;
                    }
                    if (!shardCanBeDeleted) continue;
                    ShardId shardId = indexShardRoutingTable.shardId();
                    for (File shardLocation : this.nodeEnv.shardLocations(shardId)) {
                        if (!shardLocation.exists()) continue;
                        this.logger.debug("[{}][{}] deleting shard that is no longer used", shardId.index().name(), shardId.id());
                        FileSystemUtils.deleteRecursively(shardLocation);
                    }
                }
            }
        }
    }

    static {
        MetaData.addDynamicSettings("indices.store.throttle.type", "indices.store.throttle.max_bytes_per_sec");
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            ByteSizeValue rateLimitingThrottle;
            String rateLimitingType = settings.get("indices.store.throttle.type", IndicesStore.this.rateLimitingType);
            StoreRateLimiting.Type.fromString(rateLimitingType);
            if (!rateLimitingType.equals(IndicesStore.this.rateLimitingType)) {
                IndicesStore.this.logger.info("updating indices.store.throttle.type from [{}] to [{}]", IndicesStore.this.rateLimitingType, rateLimitingType);
                IndicesStore.this.rateLimitingType = rateLimitingType;
                IndicesStore.this.rateLimiting.setType(rateLimitingType);
            }
            if (!(rateLimitingThrottle = settings.getAsBytesSize("indices.store.throttle.max_bytes_per_sec", IndicesStore.this.rateLimitingThrottle)).equals(IndicesStore.this.rateLimitingThrottle)) {
                IndicesStore.this.logger.info("updating indices.store.throttle.max_bytes_per_sec from [{}] to [{}], note, type is [{}]", IndicesStore.this.rateLimitingThrottle, rateLimitingThrottle, IndicesStore.this.rateLimitingType);
                IndicesStore.this.rateLimitingThrottle = rateLimitingThrottle;
                IndicesStore.this.rateLimiting.setMaxRate(rateLimitingThrottle);
            }
        }
    }
}

