/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.ttl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.TTLFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.selector.UidAndRoutingFieldSelector;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.node.settings.NodeSettingsService;

public class IndicesTTLService
extends AbstractLifecycleComponent<IndicesTTLService> {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final Client client;
    private volatile TimeValue interval;
    private final int bulkSize;
    private PurgerThread purgerThread;

    @Inject
    public IndicesTTLService(Settings settings, ClusterService clusterService, IndicesService indicesService, NodeSettingsService nodeSettingsService, Client client) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.client = client;
        this.interval = this.componentSettings.getAsTime("interval", TimeValue.timeValueSeconds(60L));
        this.bulkSize = this.componentSettings.getAsInt("bulk_size", 10000);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.purgerThread = new PurgerThread(EsExecutors.threadName(this.settings, "[ttl_expire]"));
        this.purgerThread.start();
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        this.purgerThread.doStop();
        this.purgerThread.interrupt();
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeShards(List<IndexShard> shardsToPurge) {
        for (IndexShard shardToPurge : shardsToPurge) {
            NumericRangeQuery query = NumericRangeQuery.newLongRange((String)"_ttl", null, (Long)System.currentTimeMillis(), (boolean)false, (boolean)true);
            Engine.Searcher searcher = shardToPurge.searcher();
            try {
                this.logger.debug("[{}][{}] purging shard", shardToPurge.routingEntry().index(), shardToPurge.routingEntry().id());
                ExpiredDocsCollector expiredDocsCollector = new ExpiredDocsCollector();
                searcher.searcher().search((Query)query, expiredDocsCollector);
                List<DocToPurge> docsToPurge = expiredDocsCollector.getDocsToPurge();
                BulkRequestBuilder bulkRequest = this.client.prepareBulk();
                for (DocToPurge docToPurge : docsToPurge) {
                    bulkRequest.add(new DeleteRequest().index(shardToPurge.routingEntry().index()).type(docToPurge.type).id(docToPurge.id).version(docToPurge.version).routing(docToPurge.routing));
                    bulkRequest = this.processBulkIfNeeded(bulkRequest, false);
                }
                this.processBulkIfNeeded(bulkRequest, true);
            }
            catch (Exception e) {
                this.logger.warn("failed to purge", e, new Object[0]);
            }
            finally {
                searcher.release();
            }
        }
    }

    private BulkRequestBuilder processBulkIfNeeded(BulkRequestBuilder bulkRequest, boolean force) {
        if (force && bulkRequest.numberOfActions() > 0 || bulkRequest.numberOfActions() >= this.bulkSize) {
            try {
                bulkRequest.execute(new ActionListener<BulkResponse>(){

                    @Override
                    public void onResponse(BulkResponse bulkResponse) {
                        IndicesTTLService.this.logger.trace("bulk took " + bulkResponse.getTookInMillis() + "ms", new Object[0]);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        IndicesTTLService.this.logger.warn("failed to execute bulk", new Object[0]);
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn("failed to process bulk", e, new Object[0]);
            }
            bulkRequest = this.client.prepareBulk();
        }
        return bulkRequest;
    }

    static {
        MetaData.addDynamicSettings("indices.ttl.interval");
        IndexMetaData.addDynamicSettings("index.ttl.disable_purge");
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue interval = settings.getAsTime("indices.ttl.interval", IndicesTTLService.this.interval);
            if (!interval.equals(IndicesTTLService.this.interval)) {
                IndicesTTLService.this.logger.info("updating indices.ttl.interval from [{}] to [{}]", IndicesTTLService.this.interval, interval);
                IndicesTTLService.this.interval = interval;
            }
        }
    }

    private class ExpiredDocsCollector
    extends Collector {
        private IndexReader indexReader;
        private List<DocToPurge> docsToPurge = new ArrayList<DocToPurge>();

        public void setScorer(Scorer scorer) {
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public void collect(int doc) {
            try {
                Document document = this.indexReader.document(doc, (FieldSelector)new UidAndRoutingFieldSelector());
                String uid = document.getFieldable(UidFieldMapper.NAME).stringValue();
                long version = UidField.loadVersion(this.indexReader, UidFieldMapper.TERM_FACTORY.createTerm(uid));
                this.docsToPurge.add(new DocToPurge(Uid.typeFromUid(uid), Uid.idFromUid(uid), version, document.get("_routing")));
            }
            catch (Exception e) {
                IndicesTTLService.this.logger.trace("failed to collect doc", e, new Object[0]);
            }
        }

        public void setNextReader(IndexReader reader, int docBase) {
            this.indexReader = reader;
        }

        public List<DocToPurge> getDocsToPurge() {
            return this.docsToPurge;
        }
    }

    private static class DocToPurge {
        public final String type;
        public final String id;
        public final long version;
        public final String routing;

        public DocToPurge(String type, String id, long version, String routing) {
            this.type = type;
            this.id = id;
            this.version = version;
            this.routing = routing;
        }
    }

    private class PurgerThread
    extends Thread {
        volatile boolean running;

        public PurgerThread(String name) {
            super(name);
            this.running = true;
            this.setDaemon(true);
        }

        public void doStop() {
            this.running = false;
        }

        @Override
        public void run() {
            while (this.running) {
                block5: {
                    try {
                        List<IndexShard> shardsToPurge = this.getShardsToPurge();
                        IndicesTTLService.this.purgeShards(shardsToPurge);
                    }
                    catch (Throwable e) {
                        if (!this.running) break block5;
                        IndicesTTLService.this.logger.warn("failed to execute ttl purge", e, new Object[0]);
                    }
                }
                try {
                    Thread.sleep(IndicesTTLService.this.interval.millis());
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private List<IndexShard> getShardsToPurge() {
            ArrayList<IndexShard> shardsToPurge = new ArrayList<IndexShard>();
            MetaData metaData = IndicesTTLService.this.clusterService.state().metaData();
            for (IndexService indexService : IndicesTTLService.this.indicesService) {
                FieldMappers ttlFieldMappers;
                boolean disablePurge;
                IndexMetaData indexMetaData = metaData.index(indexService.index().name());
                if (indexMetaData == null || (disablePurge = indexMetaData.settings().getAsBoolean("index.ttl.disable_purge", false).booleanValue()) || (ttlFieldMappers = indexService.mapperService().name("_ttl")) == null) continue;
                boolean hasTTLEnabled = false;
                for (FieldMapper ttlFieldMapper : ttlFieldMappers) {
                    if (!((TTLFieldMapper)ttlFieldMapper).enabled()) continue;
                    hasTTLEnabled = true;
                    break;
                }
                if (!hasTTLEnabled) continue;
                for (IndexShard indexShard : indexService) {
                    if (indexShard.state() != IndexShardState.STARTED || !indexShard.routingEntry().primary() || !indexShard.routingEntry().started()) continue;
                    shardsToPurge.add(indexShard);
                }
            }
            return shardsToPurge;
        }
    }
}

