/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.alias;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestIndicesAliasesAction
extends BaseRestHandler {
    @Inject
    public RestIndicesAliasesAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_aliases", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.listenerThreaded(false);
        try {
            indicesAliasesRequest.timeout(request.paramAsTime("timeout", TimeValue.timeValueSeconds(10L)));
            XContentParser parser = XContentFactory.xContent(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength()).createParser(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength());
            XContentParser.Token token = parser.nextToken();
            if (token == null) {
                throw new ElasticSearchIllegalArgumentException("No action is specified");
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.START_ARRAY) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    AliasAction.Type type;
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    String action = parser.currentName();
                    if ("add".equals(action)) {
                        type = AliasAction.Type.ADD;
                    } else if ("remove".equals(action)) {
                        type = AliasAction.Type.REMOVE;
                    } else {
                        throw new ElasticSearchIllegalArgumentException("Alias action [" + action + "] not supported");
                    }
                    String index = null;
                    String alias = null;
                    Map<String, Object> filter = null;
                    String routing = null;
                    boolean routingSet = false;
                    String indexRouting = null;
                    boolean indexRoutingSet = false;
                    String searchRouting = null;
                    boolean searchRoutingSet = false;
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("index".equals(currentFieldName)) {
                                index = parser.text();
                                continue;
                            }
                            if ("alias".equals(currentFieldName)) {
                                alias = parser.text();
                                continue;
                            }
                            if ("routing".equals(currentFieldName)) {
                                routing = parser.textOrNull();
                                routingSet = true;
                                continue;
                            }
                            if ("indexRouting".equals(currentFieldName) || "index-routing".equals(currentFieldName) || "index_routing".equals(currentFieldName)) {
                                indexRouting = parser.textOrNull();
                                indexRoutingSet = true;
                                continue;
                            }
                            if (!"searchRouting".equals(currentFieldName) && !"search-routing".equals(currentFieldName) && !"search_routing".equals(currentFieldName)) continue;
                            searchRouting = parser.textOrNull();
                            searchRoutingSet = true;
                            continue;
                        }
                        if (token != XContentParser.Token.START_OBJECT || !"filter".equals(currentFieldName)) continue;
                        filter = parser.mapOrdered();
                    }
                    if (index == null) {
                        throw new ElasticSearchIllegalArgumentException("Alias action [" + action + "] requires an [index] to be set");
                    }
                    if (alias == null) {
                        throw new ElasticSearchIllegalArgumentException("Alias action [" + action + "] requires an [alias] to be set");
                    }
                    if (type == AliasAction.Type.ADD) {
                        AliasAction aliasAction = AliasAction.newAddAliasAction(index, alias).filter(filter);
                        if (routingSet) {
                            aliasAction.routing(routing);
                        }
                        if (indexRoutingSet) {
                            aliasAction.indexRouting(indexRouting);
                        }
                        if (searchRoutingSet) {
                            aliasAction.searchRouting(searchRouting);
                        }
                        indicesAliasesRequest.addAliasAction(aliasAction);
                        continue;
                    }
                    if (type != AliasAction.Type.REMOVE) continue;
                    indicesAliasesRequest.removeAlias(index, alias);
                }
            }
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new XContentThrowableRestResponse(request, e));
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send response", e1, new Object[0]);
            }
            return;
        }
        this.client.admin().indices().aliases(indicesAliasesRequest, new ActionListener<IndicesAliasesResponse>(){

            @Override
            public void onResponse(IndicesAliasesResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject().field("ok", true).field("acknowledged", response.acknowledged()).endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestIndicesAliasesAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

