/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.support;

import java.io.IOException;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestRequest;

public class RestXContentBuilder {
    public static XContentBuilder restContentBuilder(RestRequest request) throws IOException {
        String casing;
        XContentType contentType = XContentType.fromRestContentType(request.header("Content-Type"));
        if (contentType == null && request.hasContent()) {
            contentType = XContentFactory.xContentType(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength());
        }
        if (contentType == null) {
            contentType = XContentType.JSON;
        }
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        XContentBuilder builder = new XContentBuilder(XContentFactory.xContent(contentType), cachedEntry.cachedBytes(), cachedEntry);
        if (request.paramAsBoolean("pretty", false)) {
            builder.prettyPrint();
        }
        if ((casing = request.param("case")) != null && "camelCase".equals(casing)) {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.CAMELCASE);
        } else {
            builder.fieldCaseConversion(XContentBuilder.FieldCaseConversion.NONE);
        }
        return builder;
    }

    public static void restDocumentSource(byte[] source, XContentBuilder builder, ToXContent.Params params) throws IOException {
        RestXContentBuilder.restDocumentSource(source, 0, source.length, builder, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restDocumentSource(byte[] source, int offset, int length, XContentBuilder builder, ToXContent.Params params) throws IOException {
        Compressor compressor = CompressorFactory.compressor(source, offset, length);
        if (compressor != null) {
            CompressedStreamInput compressedStreamInput = compressor.streamInput(new BytesStreamInput(source, offset, length, false));
            XContentType contentType = XContentFactory.xContentType(compressedStreamInput);
            compressedStreamInput.resetToBufferStart();
            if (contentType == builder.contentType()) {
                builder.rawField("_source", compressedStreamInput);
            } else {
                XContentParser parser = XContentFactory.xContent(contentType).createParser(compressedStreamInput);
                try {
                    parser.nextToken();
                    builder.field("_source");
                    builder.copyCurrentStructure(parser);
                }
                finally {
                    parser.close();
                }
            }
        } else {
            XContentType contentType = XContentFactory.xContentType(source, offset, length);
            if (contentType == builder.contentType()) {
                builder.rawField("_source", source, offset, length);
            } else {
                XContentParser parser = XContentFactory.xContent(contentType).createParser(source, offset, length);
                try {
                    parser.nextToken();
                    builder.field("_source");
                    builder.copyCurrentStructure(parser);
                }
                finally {
                    parser.close();
                }
            }
        }
    }
}

