/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.update;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestUpdateAction
extends BaseRestHandler {
    @Inject
    public RestUpdateAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_update", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        XContentType xContentType;
        String consistencyLevel;
        UpdateRequest updateRequest = new UpdateRequest(request.param("index"), request.param("type"), request.param("id"));
        updateRequest.listenerThreaded(false);
        updateRequest.routing(request.param("routing"));
        updateRequest.parent(request.param("parent"));
        updateRequest.timeout(request.paramAsTime("timeout", updateRequest.timeout()));
        updateRequest.refresh(request.paramAsBoolean("refresh", updateRequest.refresh()));
        String replicationType = request.param("replication");
        if (replicationType != null) {
            updateRequest.replicationType(ReplicationType.fromString(replicationType));
        }
        if ((consistencyLevel = request.param("consistency")) != null) {
            updateRequest.consistencyLevel(WriteConsistencyLevel.fromString(consistencyLevel));
        }
        updateRequest.percolate(request.param("percolate", null));
        updateRequest.script(request.param("script"));
        updateRequest.scriptLang(request.param("lang"));
        for (Map.Entry<String, String> entry : request.params().entrySet()) {
            if (!entry.getKey().startsWith("sp_")) continue;
            updateRequest.addScriptParam(entry.getKey().substring(3), entry.getValue());
        }
        updateRequest.retryOnConflict(request.paramAsInt("retry_on_conflict", updateRequest.retryOnConflict()));
        if (request.hasContent() && (xContentType = XContentFactory.xContentType(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength())) != null) {
            try {
                Map<String, Object> content = XContentFactory.xContent(xContentType).createParser(request.contentByteArray(), request.contentByteArrayOffset(), request.contentLength()).mapAndClose();
                if (content.containsKey("script")) {
                    updateRequest.script(content.get("script").toString());
                }
                if (content.containsKey("lang")) {
                    updateRequest.scriptLang(content.get("lang").toString());
                }
                if (content.containsKey("params")) {
                    updateRequest.scriptParams((Map)content.get("params"));
                }
            }
            catch (Exception e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    this.logger.warn("Failed to send response", e1, new Object[0]);
                }
                return;
            }
        }
        this.client.update(updateRequest, new ActionListener<UpdateResponse>(){

            @Override
            public void onResponse(UpdateResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject().field(Fields.OK, true).field(Fields._INDEX, response.index()).field(Fields._TYPE, response.type()).field(Fields._ID, response.id()).field(Fields._VERSION, response.version());
                    if (response.matches() != null) {
                        builder.startArray(Fields.MATCHES);
                        for (String match : response.matches()) {
                            builder.value(match);
                        }
                        builder.endArray();
                    }
                    builder.endObject();
                    RestStatus status = RestStatus.OK;
                    if (response.version() == 1L) {
                        status = RestStatus.CREATED;
                    }
                    channel.sendResponse(new XContentRestResponse(request, status, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestUpdateAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    static final class Fields {
        static final XContentBuilderString OK = new XContentBuilderString("ok");
        static final XContentBuilderString _INDEX = new XContentBuilderString("_index");
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString _ID = new XContentBuilderString("_id");
        static final XContentBuilderString _VERSION = new XContentBuilderString("_version");
        static final XContentBuilderString MATCHES = new XContentBuilderString("matches");

        Fields() {
        }
    }
}

