/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.support;

import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.support.RestUtils;

public abstract class AbstractRestRequest
implements RestRequest {
    @Override
    public final String path() {
        return RestUtils.decodeComponent(this.rawPath());
    }

    @Override
    public float paramAsFloat(String key, float defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(sValue);
        }
        catch (NumberFormatException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to parse float parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public int paramAsInt(String key, int defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public long paramAsLong(String key, long defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to parse int parameter [" + key + "] with value [" + sValue + "]", e);
        }
    }

    @Override
    public boolean paramAsBoolean(String key, boolean defaultValue) {
        return Booleans.parseBoolean(this.param(key), defaultValue);
    }

    @Override
    public Boolean paramAsBooleanOptional(String key, Boolean defaultValue) {
        String sValue = this.param(key);
        if (sValue == null) {
            return defaultValue;
        }
        return !sValue.equals("false") && !sValue.equals("0") && !sValue.equals("off");
    }

    @Override
    public TimeValue paramAsTime(String key, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.param(key), defaultValue);
    }

    @Override
    public ByteSizeValue paramAsSize(String key, ByteSizeValue defaultValue) {
        return ByteSizeValue.parseBytesSizeValue(this.param(key), defaultValue);
    }

    @Override
    public String[] paramAsStringArray(String key, String[] defaultValue) {
        String value = this.param(key);
        if (value == null) {
            return defaultValue;
        }
        return Strings.splitStringByCommaToArray(value);
    }
}

