/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river;

import java.util.Map;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Modules;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.NoClassSettingsException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.river.RiverName;
import org.elasticsearch.river.RiverSettings;
import org.elasticsearch.river.RiversTypesRegistry;

public class RiverModule
extends AbstractModule
implements SpawnModules {
    private RiverName riverName;
    private final Settings globalSettings;
    private final Map<String, Object> settings;
    private final RiversTypesRegistry typesRegistry;

    public RiverModule(RiverName riverName, Map<String, Object> settings, Settings globalSettings, RiversTypesRegistry typesRegistry) {
        this.riverName = riverName;
        this.globalSettings = globalSettings;
        this.settings = settings;
        this.typesRegistry = typesRegistry;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        return ImmutableList.of(Modules.createModule(this.loadTypeModule(this.riverName.type(), "org.elasticsearch.river.", "RiverModule"), this.globalSettings));
    }

    @Override
    protected void configure() {
        this.bind(RiverSettings.class).toInstance(new RiverSettings(this.globalSettings, this.settings));
    }

    private Class<? extends Module> loadTypeModule(String type, String prefixPackage, String suffixClassName) {
        Class<? extends Module> registered = this.typesRegistry.type(type);
        if (registered != null) {
            return registered;
        }
        String fullClassName = type;
        try {
            return this.globalSettings.getClassLoader().loadClass(fullClassName);
        }
        catch (ClassNotFoundException e) {
            fullClassName = prefixPackage + Strings.capitalize(Strings.toCamelCase(type)) + suffixClassName;
            try {
                return this.globalSettings.getClassLoader().loadClass(fullClassName);
            }
            catch (ClassNotFoundException e1) {
                fullClassName = prefixPackage + Strings.toCamelCase(type) + "." + Strings.capitalize(Strings.toCamelCase(type)) + suffixClassName;
                try {
                    return this.globalSettings.getClassLoader().loadClass(fullClassName);
                }
                catch (ClassNotFoundException e2) {
                    fullClassName = prefixPackage + Strings.toCamelCase(type).toLowerCase() + "." + Strings.capitalize(Strings.toCamelCase(type)) + suffixClassName;
                    try {
                        return this.globalSettings.getClassLoader().loadClass(fullClassName);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new NoClassSettingsException("Failed to load class with value [" + type + "]", e);
                    }
                }
            }
        }
    }
}

