/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.histogram.unbounded;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.trove.ExtTLongObjectHashMap;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.histogram.HistogramFacet;
import org.elasticsearch.search.facet.histogram.unbounded.InternalFullHistogramFacet;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptHistogramFacetCollector
extends AbstractFacetCollector {
    private final SearchScript keyScript;
    private final SearchScript valueScript;
    private final long interval;
    private final HistogramFacet.ComparatorType comparatorType;
    final ExtTLongObjectHashMap<InternalFullHistogramFacet.FullEntry> entries = CacheRecycler.popLongObjectMap();

    public ScriptHistogramFacetCollector(String facetName, String scriptLang, String keyScript, String valueScript, Map<String, Object> params, long interval, HistogramFacet.ComparatorType comparatorType, SearchContext context) {
        super(facetName);
        this.keyScript = context.scriptService().search(context.lookup(), scriptLang, keyScript, params);
        this.valueScript = context.scriptService().search(context.lookup(), scriptLang, valueScript, params);
        this.interval = interval > 0L ? interval : 0L;
        this.comparatorType = comparatorType;
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        this.keyScript.setNextDocId(doc);
        this.valueScript.setNextDocId(doc);
        long bucket = this.interval == 0L ? this.keyScript.runAsLong() : ScriptHistogramFacetCollector.bucket(this.keyScript.runAsDouble(), this.interval);
        double value = this.valueScript.runAsDouble();
        InternalFullHistogramFacet.FullEntry entry = (InternalFullHistogramFacet.FullEntry)this.entries.get(bucket);
        if (entry == null) {
            entry = new InternalFullHistogramFacet.FullEntry(bucket, 1L, value, value, 1L, value);
            this.entries.put(bucket, entry);
        } else {
            ++entry.count;
            ++entry.totalCount;
            entry.total += value;
            if (value < entry.min) {
                entry.min = value;
            }
            if (value > entry.max) {
                entry.max = value;
            }
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.keyScript.setScorer(scorer);
        this.valueScript.setScorer(scorer);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.keyScript.setNextReader(reader);
        this.valueScript.setNextReader(reader);
    }

    @Override
    public Facet facet() {
        return new InternalFullHistogramFacet(this.facetName, this.comparatorType, this.entries, true);
    }

    public static long bucket(double value, long interval) {
        return (long)(value / (double)interval) * interval;
    }
}

