/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.statistical.StatisticalFacet;

public class InternalStatisticalFacet
implements StatisticalFacet,
InternalFacet {
    private static final String STREAM_TYPE = "statistical";
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(String type, StreamInput in) throws IOException {
            return InternalStatisticalFacet.readStatisticalFacet(in);
        }
    };
    private String name;
    private double min;
    private double max;
    private double total;
    private double sumOfSquares;
    private long count;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public String streamType() {
        return STREAM_TYPE;
    }

    private InternalStatisticalFacet() {
    }

    public InternalStatisticalFacet(String name, double min, double max, double total, double sumOfSquares, long count) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.total = total;
        this.sumOfSquares = sumOfSquares;
        this.count = count;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String type() {
        return STREAM_TYPE;
    }

    @Override
    public String getType() {
        return STREAM_TYPE;
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public long getCount() {
        return this.count();
    }

    @Override
    public double total() {
        return this.total;
    }

    @Override
    public double getTotal() {
        return this.total();
    }

    @Override
    public double sumOfSquares() {
        return this.sumOfSquares;
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares();
    }

    @Override
    public double mean() {
        if (this.count == 0L) {
            return 0.0;
        }
        return this.total / (double)this.count;
    }

    @Override
    public double getMean() {
        return this.mean();
    }

    @Override
    public double min() {
        return this.min;
    }

    @Override
    public double getMin() {
        return this.min();
    }

    @Override
    public double max() {
        return this.max;
    }

    @Override
    public double getMax() {
        return this.max();
    }

    @Override
    public double variance() {
        return (this.sumOfSquares - this.total * this.total / (double)this.count) / (double)this.count;
    }

    @Override
    public double getVariance() {
        return this.variance();
    }

    @Override
    public double stdDeviation() {
        return Math.sqrt(this.variance());
    }

    @Override
    public double getStdDeviation() {
        return this.stdDeviation();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field(Fields._TYPE, STREAM_TYPE);
        builder.field(Fields.COUNT, this.count());
        builder.field(Fields.TOTAL, this.total());
        builder.field(Fields.MIN, this.min());
        builder.field(Fields.MAX, this.max());
        builder.field(Fields.MEAN, this.mean());
        builder.field(Fields.SUM_OF_SQUARES, this.sumOfSquares());
        builder.field(Fields.VARIANCE, this.variance());
        builder.field(Fields.STD_DEVIATION, this.stdDeviation());
        builder.endObject();
        return builder;
    }

    public static StatisticalFacet readStatisticalFacet(StreamInput in) throws IOException {
        InternalStatisticalFacet facet = new InternalStatisticalFacet();
        facet.readFrom(in);
        return facet;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        this.count = in.readVLong();
        this.total = in.readDouble();
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.sumOfSquares = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeVLong(this.count);
        out.writeDouble(this.total);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeDouble(this.sumOfSquares);
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString MIN = new XContentBuilderString("min");
        static final XContentBuilderString MAX = new XContentBuilderString("max");
        static final XContentBuilderString MEAN = new XContentBuilderString("mean");
        static final XContentBuilderString SUM_OF_SQUARES = new XContentBuilderString("sum_of_squares");
        static final XContentBuilderString VARIANCE = new XContentBuilderString("variance");
        static final XContentBuilderString STD_DEVIATION = new XContentBuilderString("std_deviation");

        Fields() {
        }
    }
}

