/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.io.IOException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.MoreExecutors;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.threadpool.ThreadPoolInfo;
import org.elasticsearch.threadpool.ThreadPoolStats;

public class ThreadPool
extends AbstractComponent {
    private final ImmutableMap<String, ExecutorHolder> executors;
    private final ScheduledThreadPoolExecutor scheduler;
    private final EstimatedTimeThread estimatedTimeThread;

    public ThreadPool() {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    @Inject
    public ThreadPool(Settings settings) {
        super(settings);
        Map<String, Settings> groupSettings = settings.getGroups("threadpool");
        HashMap<String, ExecutorHolder> executors = Maps.newHashMap();
        executors.put("generic", this.build("generic", "cached", groupSettings.get("generic"), ImmutableSettings.settingsBuilder().put("keep_alive", "30s").build()));
        executors.put("index", this.build("index", "cached", groupSettings.get("index"), ImmutableSettings.Builder.EMPTY_SETTINGS));
        executors.put("bulk", this.build("bulk", "cached", groupSettings.get("bulk"), ImmutableSettings.Builder.EMPTY_SETTINGS));
        executors.put("get", this.build("get", "cached", groupSettings.get("get"), ImmutableSettings.Builder.EMPTY_SETTINGS));
        executors.put("search", this.build("search", "cached", groupSettings.get("search"), ImmutableSettings.Builder.EMPTY_SETTINGS));
        executors.put("percolate", this.build("percolate", "cached", groupSettings.get("percolate"), ImmutableSettings.Builder.EMPTY_SETTINGS));
        executors.put("management", this.build("management", "scaling", groupSettings.get("management"), ImmutableSettings.settingsBuilder().put("keep_alive", "5m").put("size", 5).build()));
        executors.put("flush", this.build("flush", "scaling", groupSettings.get("flush"), ImmutableSettings.settingsBuilder().put("keep_alive", "5m").put("size", 10).build()));
        executors.put("merge", this.build("merge", "scaling", groupSettings.get("merge"), ImmutableSettings.settingsBuilder().put("keep_alive", "5m").put("size", 20).build()));
        executors.put("refresh", this.build("refresh", "cached", groupSettings.get("refresh"), ImmutableSettings.settingsBuilder().put("keep_alive", "1m").build()));
        executors.put("cache", this.build("cache", "scaling", groupSettings.get("cache"), ImmutableSettings.settingsBuilder().put("keep_alive", "5m").put("size", 4).build()));
        executors.put("snapshot", this.build("snapshot", "scaling", groupSettings.get("snapshot"), ImmutableSettings.settingsBuilder().put("keep_alive", "5m").put("size", 5).build()));
        executors.put("same", new ExecutorHolder(MoreExecutors.sameThreadExecutor(), new Info("same", "same")));
        this.executors = ImmutableMap.copyOf(executors);
        this.scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, EsExecutors.daemonThreadFactory(settings, "scheduler"));
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        TimeValue estimatedTimeInterval = this.componentSettings.getAsTime("estimated_time_interval", TimeValue.timeValueMillis(200L));
        this.estimatedTimeThread = new EstimatedTimeThread(EsExecutors.threadName(settings, "[timer]"), estimatedTimeInterval.millis());
        this.estimatedTimeThread.start();
    }

    public long estimatedTimeInMillis() {
        return this.estimatedTimeThread.estimatedTimeInMillis();
    }

    public ThreadPoolInfo info() {
        ArrayList<Info> infos = new ArrayList<Info>();
        for (ExecutorHolder holder : this.executors.values()) {
            String name = holder.info.name();
            if ("same".equals(name)) continue;
            infos.add(holder.info);
        }
        return new ThreadPoolInfo(infos);
    }

    public ThreadPoolStats stats() {
        ArrayList<ThreadPoolStats.Stats> stats = new ArrayList<ThreadPoolStats.Stats>();
        for (ExecutorHolder holder : this.executors.values()) {
            String name = holder.info.name();
            if ("same".equals(name)) continue;
            int threads = -1;
            int queue = -1;
            int active = -1;
            if (holder.executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)holder.executor;
                threads = threadPoolExecutor.getPoolSize();
                queue = threadPoolExecutor.getQueue().size();
                active = threadPoolExecutor.getActiveCount();
            }
            stats.add(new ThreadPoolStats.Stats(name, threads, queue, active));
        }
        return new ThreadPoolStats(stats);
    }

    public Executor generic() {
        return this.executor("generic");
    }

    public Executor executor(String name) {
        Executor executor = this.executors.get((Object)name).executor;
        if (executor == null) {
            throw new ElasticSearchIllegalArgumentException("No executor found for [" + name + "]");
        }
        return executor;
    }

    public ScheduledExecutorService scheduler() {
        return this.scheduler;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, TimeValue interval) {
        return this.scheduler.scheduleWithFixedDelay(new LoggingRunnable(command), interval.millis(), interval.millis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> schedule(TimeValue delay, String name, Runnable command) {
        if (!"same".equals(name)) {
            command = new ThreadedRunnable(command, this.executor(name));
        }
        return this.scheduler.schedule(command, delay.millis(), TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.estimatedTimeThread.running = false;
        this.estimatedTimeThread.interrupt();
        this.scheduler.shutdown();
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor.executor).shutdown();
        }
    }

    public void shutdownNow() {
        this.estimatedTimeThread.running = false;
        this.estimatedTimeThread.interrupt();
        this.scheduler.shutdownNow();
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor instanceof ThreadPoolExecutor)) continue;
            ((ThreadPoolExecutor)executor.executor).shutdownNow();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean result = this.scheduler.awaitTermination(timeout, unit);
        for (ExecutorHolder executor : this.executors.values()) {
            if (!(executor.executor instanceof ThreadPoolExecutor)) continue;
            result &= ((ThreadPoolExecutor)executor.executor).awaitTermination(timeout, unit);
        }
        return result;
    }

    private ExecutorHolder build(String name, String defaultType, @Nullable Settings settings, Settings defaultSettings) {
        if (settings == null) {
            settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        }
        String type = settings.get("type", defaultType);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(this.settings, name);
        if ("same".equals(type)) {
            this.logger.debug("creating thread_pool [{}], type [{}]", name, type);
            return new ExecutorHolder(MoreExecutors.sameThreadExecutor(), new Info(name, type));
        }
        if ("cached".equals(type)) {
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L)));
            this.logger.debug("creating thread_pool [{}], type [{}], keep_alive [{}]", name, type, keepAlive);
            EsThreadPoolExecutor executor = new EsThreadPoolExecutor(0, Integer.MAX_VALUE, keepAlive.millis(), TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), threadFactory);
            return new ExecutorHolder(executor, new Info(name, type, -1, -1, keepAlive, null));
        }
        if ("fixed".equals(type)) {
            RejectedExecutionHandler rejectedExecutionHandler;
            int size = settings.getAsInt("size", defaultSettings.getAsInt("size", Runtime.getRuntime().availableProcessors() * 5));
            SizeValue capacity = settings.getAsSize("capacity", settings.getAsSize("queue", settings.getAsSize("queue_size", defaultSettings.getAsSize("queue", defaultSettings.getAsSize("queue_size", null)))));
            String rejectSetting = settings.get("reject_policy", defaultSettings.get("reject_policy", "abort"));
            if ("abort".equals(rejectSetting)) {
                rejectedExecutionHandler = EsAbortPolicy.INSTANCE;
            } else if ("caller".equals(rejectSetting)) {
                rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
            } else {
                throw new ElasticSearchIllegalArgumentException("reject_policy [" + rejectSetting + "] not valid for [" + name + "] thread pool");
            }
            this.logger.debug("creating thread_pool [{}], type [{}], size [{}], queue_size [{}], reject_policy [{}]", name, type, size, capacity, rejectSetting);
            AbstractQueue workQueue = capacity == null ? new LinkedTransferQueue() : ((int)capacity.singles() > 0 ? new ArrayBlockingQueue((int)capacity.singles()) : new SynchronousQueue());
            EsThreadPoolExecutor executor = new EsThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)workQueue), threadFactory, rejectedExecutionHandler);
            return new ExecutorHolder(executor, new Info(name, type, size, size, null, capacity));
        }
        if ("scaling".equals(type)) {
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L)));
            int min = settings.getAsInt("min", defaultSettings.getAsInt("min", 1));
            int size = settings.getAsInt("max", settings.getAsInt("size", defaultSettings.getAsInt("size", Runtime.getRuntime().availableProcessors() * 5)));
            this.logger.debug("creating thread_pool [{}], type [{}], min [{}], size [{}], keep_alive [{}]", name, type, min, size, keepAlive);
            EsThreadPoolExecutor executor = EsExecutors.newScalingExecutorService(min, size, keepAlive.millis(), TimeUnit.MILLISECONDS, threadFactory);
            return new ExecutorHolder(executor, new Info(name, type, min, size, keepAlive, null));
        }
        if ("blocking".equals(type)) {
            TimeValue keepAlive = settings.getAsTime("keep_alive", defaultSettings.getAsTime("keep_alive", TimeValue.timeValueMinutes(5L)));
            int min = settings.getAsInt("min", defaultSettings.getAsInt("min", 1));
            int size = settings.getAsInt("max", settings.getAsInt("size", defaultSettings.getAsInt("size", Runtime.getRuntime().availableProcessors() * 5)));
            SizeValue capacity = settings.getAsSize("capacity", settings.getAsSize("queue_size", defaultSettings.getAsSize("queue_size", new SizeValue(1000L))));
            TimeValue waitTime = settings.getAsTime("wait_time", defaultSettings.getAsTime("wait_time", TimeValue.timeValueSeconds(60L)));
            this.logger.debug("creating thread_pool [{}], type [{}], min [{}], size [{}], queue_size [{}], keep_alive [{}], wait_time [{}]", name, type, min, size, capacity.singles(), keepAlive, waitTime);
            EsThreadPoolExecutor executor = EsExecutors.newBlockingExecutorService(min, size, keepAlive.millis(), TimeUnit.MILLISECONDS, threadFactory, (int)capacity.singles(), waitTime.millis(), TimeUnit.MILLISECONDS);
            return new ExecutorHolder(executor, new Info(name, type, min, size, keepAlive, capacity));
        }
        throw new ElasticSearchIllegalArgumentException("No type found [" + type + "], for [" + name + "]");
    }

    public static class Info
    implements Streamable,
    ToXContent {
        private String name;
        private String type;
        private int min;
        private int max;
        private TimeValue keepAlive;
        private SizeValue capacity;

        Info() {
        }

        public Info(String name, String type) {
            this(name, type, -1);
        }

        public Info(String name, String type, int size) {
            this(name, type, size, size, null, null);
        }

        public Info(String name, String type, int min, int max, @Nullable TimeValue keepAlive, @Nullable SizeValue capacity) {
            this.name = name;
            this.type = type;
            this.min = min;
            this.max = max;
            this.keepAlive = keepAlive;
            this.capacity = capacity;
        }

        public String name() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public String type() {
            return this.type;
        }

        public String getType() {
            return this.type;
        }

        public int min() {
            return this.min;
        }

        public int getMin() {
            return this.min;
        }

        public int max() {
            return this.max;
        }

        public int getMax() {
            return this.max;
        }

        @Nullable
        public TimeValue keepAlive() {
            return this.keepAlive;
        }

        @Nullable
        public TimeValue getKeepAlive() {
            return this.keepAlive;
        }

        @Nullable
        public SizeValue capacity() {
            return this.capacity;
        }

        @Nullable
        public SizeValue getCapacity() {
            return this.capacity;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readUTF();
            this.type = in.readUTF();
            this.min = in.readInt();
            this.max = in.readInt();
            if (in.readBoolean()) {
                this.keepAlive = TimeValue.readTimeValue(in);
            }
            if (in.readBoolean()) {
                this.capacity = SizeValue.readSizeValue(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeUTF(this.type);
            out.writeInt(this.min);
            out.writeInt(this.max);
            if (this.keepAlive == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.keepAlive.writeTo(out);
            }
            if (this.capacity == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.capacity.writeTo(out);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.name, XContentBuilder.FieldCaseConversion.NONE);
            builder.field(Fields.TYPE, this.type);
            if (this.min != -1) {
                builder.field(Fields.MIN, this.min);
            }
            if (this.max != -1) {
                builder.field(Fields.MAX, this.max);
            }
            if (this.keepAlive != null) {
                builder.field(Fields.KEEP_ALIVE, this.keepAlive.toString());
            }
            if (this.capacity != null) {
                builder.field(Fields.CAPACITY, this.capacity.toString());
            }
            builder.endObject();
            return builder;
        }

        static final class Fields {
            static final XContentBuilderString TYPE = new XContentBuilderString("type");
            static final XContentBuilderString MIN = new XContentBuilderString("min");
            static final XContentBuilderString MAX = new XContentBuilderString("max");
            static final XContentBuilderString KEEP_ALIVE = new XContentBuilderString("keep_alive");
            static final XContentBuilderString CAPACITY = new XContentBuilderString("capacity");

            Fields() {
            }
        }
    }

    static class ExecutorHolder {
        public final Executor executor;
        public final Info info;

        ExecutorHolder(Executor executor, Info info) {
            this.executor = executor;
            this.info = info;
        }
    }

    static class EstimatedTimeThread
    extends Thread {
        final long interval;
        volatile boolean running = true;
        volatile long estimatedTimeInMillis;

        EstimatedTimeThread(String name, long interval) {
            super(name);
            this.interval = interval;
            this.setDaemon(true);
        }

        public long estimatedTimeInMillis() {
            return this.estimatedTimeInMillis;
        }

        @Override
        public void run() {
            while (this.running) {
                this.estimatedTimeInMillis = System.currentTimeMillis();
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    this.running = false;
                    return;
                }
                try {
                    FileSystemUtils.checkMkdirsStall(this.estimatedTimeInMillis);
                }
                catch (Exception exception) {}
            }
        }
    }

    class ThreadedRunnable
    implements Runnable {
        private final Runnable runnable;
        private final Executor executor;

        ThreadedRunnable(Runnable runnable, Executor executor) {
            this.runnable = runnable;
            this.executor = executor;
        }

        @Override
        public void run() {
            this.executor.execute(this.runnable);
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }

    class LoggingRunnable
    implements Runnable {
        private final Runnable runnable;

        LoggingRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                ThreadPool.this.logger.warn("failed to run {}", e, this.runnable.toString());
            }
        }

        public int hashCode() {
            return this.runnable.hashCode();
        }

        public boolean equals(Object obj) {
            return this.runnable.equals(obj);
        }

        public String toString() {
            return "[threaded] " + this.runnable.toString();
        }
    }

    public static class Names {
        public static final String SAME = "same";
        public static final String GENERIC = "generic";
        public static final String GET = "get";
        public static final String INDEX = "index";
        public static final String BULK = "bulk";
        public static final String SEARCH = "search";
        public static final String PERCOLATE = "percolate";
        public static final String MANAGEMENT = "management";
        public static final String FLUSH = "flush";
        public static final String MERGE = "merge";
        public static final String CACHE = "cache";
        public static final String REFRESH = "refresh";
        public static final String SNAPSHOT = "snapshot";
    }
}

