/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.local;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.ThrowableObjectInputStream;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.LocalTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSerializationException;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.local.LocalTransportChannel;
import org.elasticsearch.transport.support.TransportStreams;

public class LocalTransport
extends AbstractLifecycleComponent<Transport>
implements Transport {
    private final ThreadPool threadPool;
    private volatile TransportServiceAdapter transportServiceAdapter;
    private volatile BoundTransportAddress boundAddress;
    private volatile LocalTransportAddress localAddress;
    private static final ConcurrentMap<TransportAddress, LocalTransport> transports = ConcurrentCollections.newConcurrentMap();
    private static final AtomicLong transportAddressIdGenerator = new AtomicLong();
    private final ConcurrentMap<DiscoveryNode, LocalTransport> connectedNodes = ConcurrentCollections.newConcurrentMap();

    public LocalTransport(ThreadPool threadPool) {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, threadPool);
    }

    @Inject
    public LocalTransport(Settings settings, ThreadPool threadPool) {
        super(settings);
        this.threadPool = threadPool;
    }

    @Override
    public TransportAddress[] addressesFromString(String address) {
        return new TransportAddress[]{new LocalTransportAddress(address)};
    }

    @Override
    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return LocalTransportAddress.class.equals(address);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        this.localAddress = new LocalTransportAddress(Long.toString(transportAddressIdGenerator.incrementAndGet()));
        transports.put(this.localAddress, this);
        this.boundAddress = new BoundTransportAddress(this.localAddress, this.localAddress);
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        transports.remove(this.localAddress);
        for (LocalTransport targetTransport : transports.values()) {
            for (Map.Entry entry : targetTransport.connectedNodes.entrySet()) {
                if (entry.getValue() != this) continue;
                targetTransport.disconnectFromNode((DiscoveryNode)entry.getKey());
            }
        }
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    @Override
    public void transportServiceAdapter(TransportServiceAdapter transportServiceAdapter) {
        this.transportServiceAdapter = transportServiceAdapter;
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    @Override
    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
        this.connectToNode(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectToNode(DiscoveryNode node) throws ConnectTransportException {
        LocalTransport localTransport = this;
        synchronized (localTransport) {
            if (this.connectedNodes.containsKey(node)) {
                return;
            }
            LocalTransport targetTransport = (LocalTransport)transports.get(node.address());
            if (targetTransport == null) {
                throw new ConnectTransportException(node, "Failed to connect");
            }
            this.connectedNodes.put(node, targetTransport);
            this.transportServiceAdapter.raiseNodeConnected(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        LocalTransport localTransport = this;
        synchronized (localTransport) {
            LocalTransport removed = (LocalTransport)this.connectedNodes.remove(node);
            if (removed != null) {
                this.transportServiceAdapter.raiseNodeDisconnected(node);
            }
        }
    }

    @Override
    public long serverOpen() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Streamable> void sendRequest(DiscoveryNode node, final long requestId, final String action, Streamable message, TransportRequestOptions options) throws IOException, TransportException {
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        try {
            StreamOutput stream = cachedEntry.cachedHandles();
            stream.writeLong(requestId);
            byte status = 0;
            status = TransportStreams.statusSetRequest(status);
            stream.writeByte(status);
            stream.writeUTF(action);
            message.writeTo(stream);
            stream.close();
            final LocalTransport targetTransport = (LocalTransport)this.connectedNodes.get(node);
            if (targetTransport == null) {
                throw new NodeNotConnectedException(node, "Node not connected");
            }
            final byte[] data = cachedEntry.bytes().copiedByteArray();
            this.transportServiceAdapter.sent(data.length);
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    targetTransport.messageReceived(data, action, LocalTransport.this, requestId);
                }
            });
        }
        finally {
            CachedStreamOutput.pushEntry(cachedEntry);
        }
    }

    ThreadPool threadPool() {
        return this.threadPool;
    }

    void messageReceived(byte[] data, String action, LocalTransport sourceTransport, @Nullable Long sendRequestId) {
        this.transportServiceAdapter.received(data.length);
        StreamInput stream = new BytesStreamInput(data, false);
        stream = CachedStreamInput.cachedHandles(stream);
        try {
            long requestId = stream.readLong();
            byte status = stream.readByte();
            boolean isRequest = TransportStreams.statusIsRequest(status);
            if (isRequest) {
                this.handleRequest(stream, requestId, sourceTransport);
            } else {
                TransportResponseHandler handler = this.transportServiceAdapter.remove(requestId);
                if (handler != null) {
                    if (TransportStreams.statusIsError(status)) {
                        this.handlerResponseError(stream, handler);
                    } else {
                        this.handleResponse(stream, handler);
                    }
                }
            }
        }
        catch (Exception e) {
            if (sendRequestId != null) {
                TransportResponseHandler handler = this.transportServiceAdapter.remove(sendRequestId);
                if (handler != null) {
                    handler.handleException(new RemoteTransportException(this.nodeName(), this.localAddress, action, e));
                }
            }
            this.logger.warn("Failed to receive message for action [" + action + "]", e, new Object[0]);
        }
    }

    private void handleRequest(StreamInput stream, long requestId, LocalTransport sourceTransport) throws Exception {
        String action = stream.readUTF();
        LocalTransportChannel transportChannel = new LocalTransportChannel(this, sourceTransport, action, requestId);
        try {
            TransportRequestHandler handler = this.transportServiceAdapter.handler(action);
            if (handler == null) {
                throw new ActionNotFoundTransportException("Action [" + action + "] not found");
            }
            Object streamable = handler.newInstance();
            streamable.readFrom(stream);
            handler.messageReceived(streamable, transportChannel);
        }
        catch (Exception e) {
            try {
                transportChannel.sendResponse(e);
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send error message back to client for action [" + action + "]", e, new Object[0]);
                this.logger.warn("Actual Exception", e1, new Object[0]);
            }
        }
    }

    private void handleResponse(StreamInput buffer, final TransportResponseHandler handler) {
        Object streamable = handler.newInstance();
        try {
            streamable.readFrom(buffer);
        }
        catch (Exception e) {
            this.handleException(handler, new TransportSerializationException("Failed to deserialize response of type [" + streamable.getClass().getName() + "]", e));
            return;
        }
        this.threadPool.executor(handler.executor()).execute(new Runnable((Streamable)streamable){
            final /* synthetic */ Streamable val$streamable;
            {
                this.val$streamable = streamable;
            }

            @Override
            public void run() {
                try {
                    handler.handleResponse(this.val$streamable);
                }
                catch (Exception e) {
                    LocalTransport.this.handleException(handler, new ResponseHandlerFailureTransportException(e));
                }
            }
        });
    }

    private void handlerResponseError(StreamInput buffer, TransportResponseHandler handler) {
        Throwable error;
        try {
            ThrowableObjectInputStream ois = new ThrowableObjectInputStream(buffer, this.settings.getClassLoader());
            error = (Throwable)ois.readObject();
        }
        catch (Exception e) {
            error = new TransportSerializationException("Failed to deserialize exception response from stream", e);
        }
        this.handleException(handler, error);
    }

    private void handleException(TransportResponseHandler handler, Throwable error) {
        if (!(error instanceof RemoteTransportException)) {
            error = new RemoteTransportException("None remote transport exception", error);
        }
        RemoteTransportException rtx = (RemoteTransportException)error;
        handler.handleException(rtx);
    }
}

