/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.netty.NettyStaticSetup;
import org.elasticsearch.common.netty.OpenChannelsHandler;
import org.elasticsearch.common.netty.bootstrap.ClientBootstrap;
import org.elasticsearch.common.netty.bootstrap.ServerBootstrap;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelFuture;
import org.elasticsearch.common.netty.channel.ChannelFutureListener;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.ChannelPipelineFactory;
import org.elasticsearch.common.netty.channel.Channels;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.NetworkExceptionHelper;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.netty.MessageChannelHandler;
import org.elasticsearch.transport.support.TransportStreams;

public class NettyTransport
extends AbstractLifecycleComponent<Transport>
implements Transport {
    private final NetworkService networkService;
    final int workerCount;
    final boolean blockingServer;
    final boolean blockingClient;
    final String port;
    final String bindHost;
    final String publishHost;
    final boolean compress;
    final TimeValue connectTimeout;
    final Boolean tcpNoDelay;
    final Boolean tcpKeepAlive;
    final Boolean reuseAddress;
    final ByteSizeValue tcpSendBufferSize;
    final ByteSizeValue tcpReceiveBufferSize;
    final int connectionsPerNodeLow;
    final int connectionsPerNodeMed;
    final int connectionsPerNodeHigh;
    private final ThreadPool threadPool;
    private volatile OpenChannelsHandler serverOpenChannels;
    private volatile ClientBootstrap clientBootstrap;
    private volatile ServerBootstrap serverBootstrap;
    final ConcurrentMap<DiscoveryNode, NodeChannels> connectedNodes = ConcurrentCollections.newConcurrentMap();
    private volatile Channel serverChannel;
    private volatile TransportServiceAdapter transportServiceAdapter;
    private volatile BoundTransportAddress boundAddress;
    private final Object[] connectMutex;

    public NettyTransport(ThreadPool threadPool) {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, threadPool, new NetworkService(ImmutableSettings.Builder.EMPTY_SETTINGS));
    }

    public NettyTransport(Settings settings, ThreadPool threadPool) {
        this(settings, threadPool, new NetworkService(settings));
    }

    @Inject
    public NettyTransport(Settings settings, ThreadPool threadPool, NetworkService networkService) {
        super(settings);
        this.threadPool = threadPool;
        this.networkService = networkService;
        this.connectMutex = new Object[500];
        for (int i = 0; i < this.connectMutex.length; ++i) {
            this.connectMutex[i] = new Object();
        }
        this.workerCount = this.componentSettings.getAsInt("worker_count", Runtime.getRuntime().availableProcessors() * 2);
        this.blockingServer = settings.getAsBoolean("transport.tcp.blocking_server", settings.getAsBoolean("network.tcp.blocking_server", settings.getAsBoolean("network.tcp.blocking", false)));
        this.blockingClient = settings.getAsBoolean("transport.tcp.blocking_client", settings.getAsBoolean("network.tcp.blocking_client", settings.getAsBoolean("network.tcp.blocking", false)));
        this.port = this.componentSettings.get("port", settings.get("transport.tcp.port", "9300-9400"));
        this.bindHost = this.componentSettings.get("bind_host", settings.get("transport.bind_host", settings.get("transport.host")));
        this.publishHost = this.componentSettings.get("publish_host", settings.get("transport.publish_host", settings.get("transport.host")));
        this.compress = settings.getAsBoolean("transport.tcp.compress", false);
        this.connectTimeout = this.componentSettings.getAsTime("connect_timeout", settings.getAsTime("transport.tcp.connect_timeout", settings.getAsTime("network.tcp.connect_timeout", NetworkService.TcpSettings.TCP_DEFAULT_CONNECT_TIMEOUT)));
        this.tcpNoDelay = this.componentSettings.getAsBoolean("tcp_no_delay", settings.getAsBoolean("network.tcp.no_delay", true));
        this.tcpKeepAlive = this.componentSettings.getAsBoolean("tcp_keep_alive", settings.getAsBoolean("network.tcp.keep_alive", true));
        this.reuseAddress = this.componentSettings.getAsBoolean("reuse_address", settings.getAsBoolean("network.tcp.reuse_address", NetworkUtils.defaultReuseAddress()));
        this.tcpSendBufferSize = this.componentSettings.getAsBytesSize("tcp_send_buffer_size", settings.getAsBytesSize("network.tcp.send_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_SEND_BUFFER_SIZE));
        this.tcpReceiveBufferSize = this.componentSettings.getAsBytesSize("tcp_receive_buffer_size", settings.getAsBytesSize("network.tcp.receive_buffer_size", NetworkService.TcpSettings.TCP_DEFAULT_RECEIVE_BUFFER_SIZE));
        this.connectionsPerNodeLow = this.componentSettings.getAsInt("connections_per_node.low", settings.getAsInt("transport.connections_per_node.low", 2));
        this.connectionsPerNodeMed = this.componentSettings.getAsInt("connections_per_node.med", settings.getAsInt("transport.connections_per_node.med", 6));
        this.connectionsPerNodeHigh = this.componentSettings.getAsInt("connections_per_node.high", settings.getAsInt("transport.connections_per_node.high", 1));
        this.logger.debug("using worker_count[{}], port[{}], bind_host[{}], publish_host[{}], compress[{}], connect_timeout[{}], connections_per_node[{}/{}/{}]", this.workerCount, this.port, this.bindHost, this.publishHost, this.compress, this.connectTimeout, this.connectionsPerNodeLow, this.connectionsPerNodeMed, this.connectionsPerNodeHigh);
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public void transportServiceAdapter(TransportServiceAdapter service) {
        this.transportServiceAdapter = service;
    }

    TransportServiceAdapter transportServiceAdapter() {
        return this.transportServiceAdapter;
    }

    ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        InetSocketAddress publishAddress;
        InetAddress hostAddressX;
        this.clientBootstrap = this.blockingClient ? new ClientBootstrap(new OioClientSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_worker")))) : new ClientBootstrap(new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_boss")), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_client_worker")), this.workerCount));
        ChannelPipelineFactory clientPipelineFactory = new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("dispatcher", new MessageChannelHandler(NettyTransport.this, NettyTransport.this.logger));
                return pipeline;
            }
        };
        this.clientBootstrap.setPipelineFactory(clientPipelineFactory);
        this.clientBootstrap.setOption("connectTimeoutMillis", this.connectTimeout.millis());
        if (this.tcpNoDelay != null) {
            this.clientBootstrap.setOption("tcpNoDelay", this.tcpNoDelay);
        }
        if (this.tcpKeepAlive != null) {
            this.clientBootstrap.setOption("keepAlive", this.tcpKeepAlive);
        }
        if (this.tcpSendBufferSize != null) {
            this.clientBootstrap.setOption("sendBufferSize", this.tcpSendBufferSize.bytes());
        }
        if (this.tcpReceiveBufferSize != null) {
            this.clientBootstrap.setOption("receiveBufferSize", this.tcpReceiveBufferSize.bytes());
        }
        if (this.reuseAddress != null) {
            this.clientBootstrap.setOption("reuseAddress", this.reuseAddress);
        }
        if (!this.settings.getAsBoolean("network.server", true).booleanValue()) {
            return;
        }
        this.serverOpenChannels = new OpenChannelsHandler(this.logger);
        this.serverBootstrap = this.blockingServer ? new ServerBootstrap(new OioServerSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_boss")), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_worker")))) : new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_boss")), Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory(this.settings, "transport_server_worker")), this.workerCount));
        ChannelPipelineFactory serverPipelineFactory = new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                pipeline.addLast("openChannels", NettyTransport.this.serverOpenChannels);
                pipeline.addLast("dispatcher", new MessageChannelHandler(NettyTransport.this, NettyTransport.this.logger));
                return pipeline;
            }
        };
        this.serverBootstrap.setPipelineFactory(serverPipelineFactory);
        if (this.tcpNoDelay != null) {
            this.serverBootstrap.setOption("child.tcpNoDelay", this.tcpNoDelay);
        }
        if (this.tcpKeepAlive != null) {
            this.serverBootstrap.setOption("child.keepAlive", this.tcpKeepAlive);
        }
        if (this.tcpSendBufferSize != null) {
            this.serverBootstrap.setOption("child.sendBufferSize", this.tcpSendBufferSize.bytes());
        }
        if (this.tcpReceiveBufferSize != null) {
            this.serverBootstrap.setOption("child.receiveBufferSize", this.tcpReceiveBufferSize.bytes());
        }
        if (this.reuseAddress != null) {
            this.serverBootstrap.setOption("reuseAddress", this.reuseAddress);
            this.serverBootstrap.setOption("child.reuseAddress", this.reuseAddress);
        }
        try {
            hostAddressX = this.networkService.resolveBindHostAddress(this.bindHost);
        }
        catch (IOException e) {
            throw new BindTransportException("Failed to resolve host [" + this.bindHost + "]", e);
        }
        final InetAddress hostAddress = hostAddressX;
        PortsRange portsRange = new PortsRange(this.port);
        final AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(new PortsRange.PortCallback(){

            @Override
            public boolean onPortNumber(int portNumber) {
                try {
                    NettyTransport.this.serverChannel = NettyTransport.this.serverBootstrap.bind(new InetSocketAddress(hostAddress, portNumber));
                }
                catch (Exception e) {
                    lastException.set(e);
                    return false;
                }
                return true;
            }
        });
        if (!success) {
            throw new BindTransportException("Failed to bind to [" + this.port + "]", (Throwable)lastException.get());
        }
        this.logger.debug("Bound to address [{}]", this.serverChannel.getLocalAddress());
        InetSocketAddress boundAddress = (InetSocketAddress)this.serverChannel.getLocalAddress();
        try {
            publishAddress = new InetSocketAddress(this.networkService.resolvePublishHostAddress(this.publishHost), boundAddress.getPort());
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        this.boundAddress = new BoundTransportAddress(new InetSocketTransportAddress(boundAddress), new InetSocketTransportAddress(publishAddress));
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.threadPool.generic().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    NodeChannels nodeChannels;
                    Iterator it = NettyTransport.this.connectedNodes.values().iterator();
                    while (it.hasNext()) {
                        nodeChannels = (NodeChannels)it.next();
                        it.remove();
                        nodeChannels.close();
                    }
                    if (NettyTransport.this.serverChannel != null) {
                        try {
                            NettyTransport.this.serverChannel.close().awaitUninterruptibly();
                        }
                        finally {
                            NettyTransport.this.serverChannel = null;
                        }
                    }
                    if (NettyTransport.this.serverOpenChannels != null) {
                        NettyTransport.this.serverOpenChannels.close();
                        NettyTransport.this.serverOpenChannels = null;
                    }
                    if (NettyTransport.this.serverBootstrap != null) {
                        NettyTransport.this.serverBootstrap.releaseExternalResources();
                        NettyTransport.this.serverBootstrap = null;
                    }
                    it = NettyTransport.this.connectedNodes.values().iterator();
                    while (it.hasNext()) {
                        nodeChannels = (NodeChannels)it.next();
                        it.remove();
                        nodeChannels.close();
                    }
                    if (NettyTransport.this.clientBootstrap != null) {
                        NettyTransport.this.clientBootstrap.releaseExternalResources();
                        NettyTransport.this.clientBootstrap = null;
                    }
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    @Override
    public TransportAddress[] addressesFromString(String address) throws Exception {
        int index = address.indexOf(91);
        if (index != -1) {
            String host = address.substring(0, index);
            Set<String> ports = Strings.commaDelimitedListToSet(address.substring(index + 1, address.indexOf(93)));
            ArrayList<InetSocketTransportAddress> addresses = Lists.newArrayList();
            for (String port : ports) {
                int[] iPorts;
                for (int iPort : iPorts = new PortsRange(port).ports()) {
                    addresses.add(new InetSocketTransportAddress(host, iPort));
                }
            }
            return addresses.toArray(new TransportAddress[addresses.size()]);
        }
        index = address.lastIndexOf(58);
        if (index == -1) {
            int[] iPorts;
            ArrayList<InetSocketTransportAddress> addresses = Lists.newArrayList();
            for (int iPort : iPorts = new PortsRange(this.port).ports()) {
                addresses.add(new InetSocketTransportAddress(address, iPort));
            }
            return addresses.toArray(new TransportAddress[addresses.size()]);
        }
        String host = address.substring(0, index);
        int port = Integer.parseInt(address.substring(index + 1));
        return new TransportAddress[]{new InetSocketTransportAddress(host, port)};
    }

    @Override
    public boolean addressSupported(Class<? extends TransportAddress> address) {
        return InetSocketTransportAddress.class.equals(address);
    }

    @Override
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (!this.lifecycle.started()) {
            // empty if block
        }
        if (NetworkExceptionHelper.isCloseConnectionException(e.getCause())) {
            Channel channel = ctx.getChannel();
            for (Map.Entry entry : this.connectedNodes.entrySet()) {
                if (!((NodeChannels)entry.getValue()).hasChannel(channel)) continue;
                this.disconnectFromNode((DiscoveryNode)entry.getKey());
            }
        } else if (NetworkExceptionHelper.isConnectException(e.getCause())) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("(Ignoring) Exception caught on netty layer [" + ctx.getChannel() + "]", e.getCause(), new Object[0]);
            }
        } else {
            this.logger.warn("Exception caught on netty layer [" + ctx.getChannel() + "]", e.getCause(), new Object[0]);
        }
    }

    TransportAddress wrapAddress(SocketAddress socketAddress) {
        return new InetSocketTransportAddress((InetSocketAddress)socketAddress);
    }

    @Override
    public long serverOpen() {
        OpenChannelsHandler channels = this.serverOpenChannels;
        return channels == null ? 0L : channels.numberOfOpenChannels();
    }

    @Override
    public <T extends Streamable> void sendRequest(DiscoveryNode node, long requestId, String action, Streamable message, TransportRequestOptions options) throws IOException, TransportException {
        Channel targetChannel = this.nodeChannel(node, options);
        if (this.compress) {
            options.withCompress(true);
        }
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        TransportStreams.buildRequest(cachedEntry, requestId, action, message, options);
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer(cachedEntry.bytes().underlyingBytes(), 0, cachedEntry.bytes().size());
        ChannelFuture future = targetChannel.write(buffer);
        future.addListener(new CacheFutureListener(cachedEntry));
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.connectedNodes.containsKey(node);
    }

    @Override
    public void connectToNodeLight(DiscoveryNode node) throws ConnectTransportException {
        this.connectToNode(node, true);
    }

    @Override
    public void connectToNode(DiscoveryNode node) {
        this.connectToNode(node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToNode(DiscoveryNode node, boolean light) {
        if (!this.lifecycle.started()) {
            throw new ElasticSearchIllegalStateException("Can't add nodes to a stopped transport");
        }
        if (node == null) {
            throw new ConnectTransportException(null, "Can't connect to a null node");
        }
        Object object = this.connectLock(node.id());
        synchronized (object) {
            try {
                NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
                if (nodeChannels != null) {
                    return;
                }
                if (light) {
                    nodeChannels = this.connectToChannelsLight(node);
                } else {
                    nodeChannels = new NodeChannels(new Channel[this.connectionsPerNodeLow], new Channel[this.connectionsPerNodeMed], new Channel[this.connectionsPerNodeHigh]);
                    try {
                        this.connectToChannels(nodeChannels, node);
                    }
                    catch (Exception e) {
                        nodeChannels.close();
                        throw e;
                    }
                }
                NodeChannels existing = this.connectedNodes.putIfAbsent(node, nodeChannels);
                if (existing != null) {
                    nodeChannels.close();
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("connected to node [{}]", node);
                    }
                    this.transportServiceAdapter.raiseNodeConnected(node);
                }
            }
            catch (ConnectTransportException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConnectTransportException(node, "General node connection failure", e);
            }
        }
    }

    private NodeChannels connectToChannelsLight(DiscoveryNode node) {
        InetSocketAddress address = ((InetSocketTransportAddress)node.address()).address();
        ChannelFuture connect = this.clientBootstrap.connect(address);
        connect.awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
        if (!connect.isSuccess()) {
            throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connect.getCause());
        }
        Channel[] channels = new Channel[]{connect.getChannel()};
        channels[0].getCloseFuture().addListener(new ChannelCloseListener(node));
        return new NodeChannels(channels, channels, channels);
    }

    private void connectToChannels(NodeChannels nodeChannels, DiscoveryNode node) {
        int i;
        Object[] connectLow = new ChannelFuture[nodeChannels.low.length];
        Object[] connectMed = new ChannelFuture[nodeChannels.med.length];
        Object[] connectHigh = new ChannelFuture[nodeChannels.high.length];
        InetSocketAddress address = ((InetSocketTransportAddress)node.address()).address();
        for (i = 0; i < connectLow.length; ++i) {
            connectLow[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectMed.length; ++i) {
            connectMed[i] = this.clientBootstrap.connect(address);
        }
        for (i = 0; i < connectHigh.length; ++i) {
            connectHigh[i] = this.clientBootstrap.connect(address);
        }
        try {
            for (i = 0; i < connectLow.length; ++i) {
                connectLow[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectLow[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectLow[i].getCause());
                }
                ((NodeChannels)nodeChannels).low[i] = connectLow[i].getChannel();
                nodeChannels.low[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectMed.length; ++i) {
                connectMed[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectMed[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectMed[i].getCause());
                }
                ((NodeChannels)nodeChannels).med[i] = connectMed[i].getChannel();
                nodeChannels.med[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            for (i = 0; i < connectHigh.length; ++i) {
                connectHigh[i].awaitUninterruptibly((long)((double)this.connectTimeout.millis() * 1.5));
                if (!connectHigh[i].isSuccess()) {
                    throw new ConnectTransportException(node, "connect_timeout[" + this.connectTimeout + "]", connectHigh[i].getCause());
                }
                ((NodeChannels)nodeChannels).high[i] = connectHigh[i].getChannel();
                nodeChannels.high[i].getCloseFuture().addListener(new ChannelCloseListener(node));
            }
            if (nodeChannels.low.length == 0) {
                if (nodeChannels.med.length > 0) {
                    NodeChannels.access$702(nodeChannels, nodeChannels.med);
                } else {
                    NodeChannels.access$702(nodeChannels, nodeChannels.high);
                }
            }
            if (nodeChannels.med.length == 0) {
                if (nodeChannels.high.length > 0) {
                    NodeChannels.access$802(nodeChannels, nodeChannels.high);
                } else {
                    NodeChannels.access$802(nodeChannels, nodeChannels.low);
                }
            }
            if (nodeChannels.high.length == 0) {
                if (nodeChannels.med.length > 0) {
                    NodeChannels.access$902(nodeChannels, nodeChannels.med);
                } else {
                    NodeChannels.access$902(nodeChannels, nodeChannels.low);
                }
            }
        }
        catch (RuntimeException e) {
            for (ChannelFuture future : ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(connectLow)).add(connectMed)).add(connectHigh)).build()) {
                future.cancel();
                if (future.getChannel() == null || !future.getChannel().isOpen()) continue;
                try {
                    future.getChannel().close();
                }
                catch (Exception e1) {}
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        Object object = this.connectLock(node.id());
        synchronized (object) {
            NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.remove(node);
            if (nodeChannels != null) {
                try {
                    nodeChannels.close();
                }
                catch (Throwable throwable) {
                    this.logger.debug("disconnected from [{}]", node);
                    this.transportServiceAdapter.raiseNodeDisconnected(node);
                    throw throwable;
                }
                this.logger.debug("disconnected from [{}]", node);
                this.transportServiceAdapter.raiseNodeDisconnected(node);
            }
        }
    }

    private Channel nodeChannel(DiscoveryNode node, TransportRequestOptions options) throws ConnectTransportException {
        NodeChannels nodeChannels = (NodeChannels)this.connectedNodes.get(node);
        if (nodeChannels == null) {
            throw new NodeNotConnectedException(node, "Node not connected");
        }
        return nodeChannels.channel(options.type());
    }

    private Object connectLock(String nodeId) {
        int hash = nodeId.hashCode();
        if (hash == Integer.MIN_VALUE) {
            hash = 0;
        }
        return this.connectMutex[Math.abs(hash) % this.connectMutex.length];
    }

    static {
        NettyStaticSetup.setup();
    }

    public static class CacheFutureListener
    implements ChannelFutureListener {
        private final CachedStreamOutput.Entry cachedEntry;

        public CacheFutureListener(CachedStreamOutput.Entry cachedEntry) {
            this.cachedEntry = cachedEntry;
        }

        @Override
        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            CachedStreamOutput.pushEntry(this.cachedEntry);
        }
    }

    public static class NodeChannels {
        private Channel[] low;
        private final AtomicInteger lowCounter = new AtomicInteger();
        private Channel[] med;
        private final AtomicInteger medCounter = new AtomicInteger();
        private Channel[] high;
        private final AtomicInteger highCounter = new AtomicInteger();

        public NodeChannels(Channel[] low, Channel[] med, Channel[] high) {
            this.low = low;
            this.med = med;
            this.high = high;
        }

        public boolean hasChannel(Channel channel) {
            return this.hasChannel(channel, this.low) || this.hasChannel(channel, this.med) || this.hasChannel(channel, this.high);
        }

        private boolean hasChannel(Channel channel, Channel[] channels) {
            for (Channel channel1 : channels) {
                if (!channel.equals(channel1)) continue;
                return true;
            }
            return false;
        }

        public Channel channel(TransportRequestOptions.Type type) {
            if (type == TransportRequestOptions.Type.MED) {
                return this.med[Math.abs(this.medCounter.incrementAndGet()) % this.med.length];
            }
            if (type == TransportRequestOptions.Type.HIGH) {
                return this.high[Math.abs(this.highCounter.incrementAndGet()) % this.high.length];
            }
            return this.low[Math.abs(this.lowCounter.incrementAndGet()) % this.low.length];
        }

        public synchronized void close() {
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
            this.closeChannelsAndWait(this.low, futures);
            this.closeChannelsAndWait(this.med, futures);
            this.closeChannelsAndWait(this.high, futures);
            for (ChannelFuture future : futures) {
                future.awaitUninterruptibly();
            }
        }

        private void closeChannelsAndWait(Channel[] channels, List<ChannelFuture> futures) {
            for (Channel channel : channels) {
                try {
                    if (channel == null || !channel.isOpen()) continue;
                    futures.add(channel.close());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        static /* synthetic */ Channel[] access$702(NodeChannels x0, Channel[] x1) {
            x0.low = x1;
            return x1;
        }

        static /* synthetic */ Channel[] access$802(NodeChannels x0, Channel[] x1) {
            x0.med = x1;
            return x1;
        }

        static /* synthetic */ Channel[] access$902(NodeChannels x0, Channel[] x1) {
            x0.high = x1;
            return x1;
        }
    }

    private class ChannelCloseListener
    implements ChannelFutureListener {
        private final DiscoveryNode node;

        private ChannelCloseListener(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            NettyTransport.this.disconnectFromNode(this.node);
        }
    }
}

