/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class AccessControlList
implements Writable {
    public static final String WILDCARD_ACL_VALUE = "*";
    private static final int INITIAL_CAPACITY = 256;
    private Set<String> users;
    private Set<String> groups;
    private boolean allAllowed;
    private Groups groupsMapping = Groups.getUserToGroupsMappingService(new Configuration());

    public AccessControlList() {
    }

    public AccessControlList(String aclString) {
        this.buildACL(aclString);
    }

    private void buildACL(String aclString) {
        this.users = new TreeSet<String>();
        this.groups = new TreeSet<String>();
        if (this.isWildCardACLValue(aclString)) {
            this.allAllowed = true;
        } else {
            this.allAllowed = false;
            String[] userGroupStrings = aclString.split(" ", 2);
            if (userGroupStrings.length >= 1) {
                LinkedList<String> usersList = new LinkedList<String>(Arrays.asList(userGroupStrings[0].split(",")));
                AccessControlList.cleanupList(usersList);
                AccessControlList.addToSet(this.users, usersList);
            }
            if (userGroupStrings.length == 2) {
                LinkedList<String> groupsList = new LinkedList<String>(Arrays.asList(userGroupStrings[1].split(",")));
                AccessControlList.cleanupList(groupsList);
                AccessControlList.addToSet(this.groups, groupsList);
                this.groupsMapping.cacheGroupsAdd(groupsList);
            }
        }
    }

    private boolean isWildCardACLValue(String aclString) {
        return aclString.contains(WILDCARD_ACL_VALUE) && aclString.trim().equals(WILDCARD_ACL_VALUE);
    }

    public boolean isAllAllowed() {
        return this.allAllowed;
    }

    public void addUser(String user) {
        if (this.isWildCardACLValue(user)) {
            throw new IllegalArgumentException("User " + user + " can not be added");
        }
        if (!this.isAllAllowed()) {
            this.users.add(user);
        }
    }

    public void addGroup(String group) {
        if (this.isWildCardACLValue(group)) {
            throw new IllegalArgumentException("Group " + group + " can not be added");
        }
        if (!this.isAllAllowed()) {
            LinkedList<String> groupsList = new LinkedList<String>();
            groupsList.add(group);
            this.groupsMapping.cacheGroupsAdd(groupsList);
            this.groups.add(group);
        }
    }

    public void removeUser(String user) {
        if (this.isWildCardACLValue(user)) {
            throw new IllegalArgumentException("User " + user + " can not be removed");
        }
        if (!this.isAllAllowed()) {
            this.users.remove(user);
        }
    }

    public void removeGroup(String group) {
        if (this.isWildCardACLValue(group)) {
            throw new IllegalArgumentException("Group " + group + " can not be removed");
        }
        if (!this.isAllAllowed()) {
            this.groups.remove(group);
        }
    }

    Set<String> getUsers() {
        return this.users;
    }

    Set<String> getGroups() {
        return this.groups;
    }

    public boolean isUserAllowed(UserGroupInformation ugi) {
        if (this.allAllowed || this.users.contains(ugi.getShortUserName())) {
            return true;
        }
        for (String group : ugi.getGroupNames()) {
            if (!this.groups.contains(group)) continue;
            return true;
        }
        return false;
    }

    private static final void cleanupList(List<String> list) {
        ListIterator<String> i = list.listIterator();
        while (i.hasNext()) {
            String s = i.next();
            if (s.length() == 0) {
                i.remove();
                continue;
            }
            s = s.trim();
            i.set(s);
        }
    }

    private static final void addToSet(Set<String> set, List<String> list) {
        for (String s : list) {
            set.add(s);
        }
    }

    public String toString() {
        String str = null;
        if (this.allAllowed) {
            str = "All users are allowed";
        } else if (this.users.isEmpty() && this.groups.isEmpty()) {
            str = "No users are allowed";
        } else {
            String usersStr = null;
            String groupsStr = null;
            if (!this.users.isEmpty()) {
                usersStr = this.users.toString();
            }
            if (!this.groups.isEmpty()) {
                groupsStr = this.groups.toString();
            }
            str = !this.users.isEmpty() && !this.groups.isEmpty() ? "Users " + usersStr + " and members of the groups " + groupsStr + " are allowed" : (!this.users.isEmpty() ? "Users " + usersStr + " are allowed" : "Members of the groups " + groupsStr + " are allowed");
        }
        return str;
    }

    public String getAclString() {
        StringBuilder sb = new StringBuilder(256);
        if (this.allAllowed) {
            sb.append('*');
        } else {
            sb.append(this.getUsersString());
            sb.append(" ");
            sb.append(this.getGroupsString());
        }
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        String aclString = this.getAclString();
        Text.writeString(out, aclString);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String aclString = Text.readString(in);
        this.buildACL(aclString);
    }

    private String getUsersString() {
        return this.getString(this.users);
    }

    private String getGroupsString() {
        return this.getString(this.groups);
    }

    private String getString(Set<String> strings) {
        StringBuilder sb = new StringBuilder(256);
        boolean first = true;
        for (String str : strings) {
            if (!first) {
                sb.append(",");
            } else {
                first = false;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    static {
        WritableFactories.setFactory(AccessControlList.class, new WritableFactory(){

            @Override
            public Writable newInstance() {
                return new AccessControlList();
            }
        });
    }
}

