/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import com.yahoo.ycsb.db.JdbcDBClientConstants;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JdbcDBClient
extends DB
implements JdbcDBClientConstants {
    private ArrayList<Connection> conns;
    private boolean initialized = false;
    private Properties props;
    private Integer jdbcFetchSize;
    private static final String DEFAULT_PROP = "";
    private ConcurrentMap<StatementType, PreparedStatement> cachedStatements;

    private int getShardIndexByKey(String key) {
        int ret = Math.abs(key.hashCode()) % this.conns.size();
        return ret;
    }

    private Connection getShardConnectionByKey(String key) {
        return this.conns.get(this.getShardIndexByKey(key));
    }

    private void cleanupAllConnections() throws SQLException {
        for (Connection conn : this.conns) {
            conn.close();
        }
    }

    public void init() throws DBException {
        if (this.initialized) {
            System.err.println("Client connection already initialized.");
            return;
        }
        this.props = this.getProperties();
        String urls = this.props.getProperty("db.url", DEFAULT_PROP);
        String user = this.props.getProperty("db.user", DEFAULT_PROP);
        String passwd = this.props.getProperty("db.passwd", DEFAULT_PROP);
        String driver = this.props.getProperty("db.driver");
        String jdbcFetchSizeStr = this.props.getProperty("jdbc.fetchsize");
        if (jdbcFetchSizeStr != null) {
            try {
                this.jdbcFetchSize = Integer.parseInt(jdbcFetchSizeStr);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Invalid JDBC fetch size specified: " + jdbcFetchSizeStr);
                throw new DBException((Throwable)nfe);
            }
        }
        String autoCommitStr = this.props.getProperty("jdbc.autocommit", Boolean.TRUE.toString());
        Boolean autoCommit = Boolean.parseBoolean(autoCommitStr);
        try {
            if (driver != null) {
                Class.forName(driver);
            }
            int shardCount = 0;
            this.conns = new ArrayList(3);
            for (String url : urls.split(",")) {
                System.out.println("Adding shard node URL: " + url);
                Connection conn = DriverManager.getConnection(url, user, passwd);
                conn.setAutoCommit(autoCommit);
                ++shardCount;
                this.conns.add(conn);
            }
            System.out.println("Using " + shardCount + " shards");
            this.cachedStatements = new ConcurrentHashMap<StatementType, PreparedStatement>();
        }
        catch (ClassNotFoundException e) {
            System.err.println("Error in initializing the JDBS driver: " + e);
            throw new DBException((Throwable)e);
        }
        catch (SQLException e) {
            System.err.println("Error in database operation: " + e);
            throw new DBException((Throwable)e);
        }
        catch (NumberFormatException e) {
            System.err.println("Invalid value for fieldcount property. " + e);
            throw new DBException((Throwable)e);
        }
        this.initialized = true;
    }

    public void cleanup() throws DBException {
        try {
            this.cleanupAllConnections();
        }
        catch (SQLException e) {
            System.err.println("Error in closing the connection. " + e);
            throw new DBException((Throwable)e);
        }
    }

    private PreparedStatement createAndCacheInsertStatement(StatementType insertType, String key) throws SQLException {
        StringBuilder insert = new StringBuilder("INSERT INTO ");
        insert.append(insertType.tableName);
        insert.append(" VALUES(?");
        for (int i = 0; i < insertType.numFields; ++i) {
            insert.append(",?");
        }
        insert.append(");");
        PreparedStatement insertStatement = this.getShardConnectionByKey(key).prepareStatement(insert.toString());
        PreparedStatement stmt = this.cachedStatements.putIfAbsent(insertType, insertStatement);
        if (stmt == null) {
            return insertStatement;
        }
        return stmt;
    }

    private PreparedStatement createAndCacheReadStatement(StatementType readType, String key) throws SQLException {
        StringBuilder read = new StringBuilder("SELECT * FROM ");
        read.append(readType.tableName);
        read.append(" WHERE ");
        read.append("YCSB_KEY");
        read.append(" = ");
        read.append("?;");
        PreparedStatement readStatement = this.getShardConnectionByKey(key).prepareStatement(read.toString());
        PreparedStatement stmt = this.cachedStatements.putIfAbsent(readType, readStatement);
        if (stmt == null) {
            return readStatement;
        }
        return stmt;
    }

    private PreparedStatement createAndCacheDeleteStatement(StatementType deleteType, String key) throws SQLException {
        StringBuilder delete = new StringBuilder("DELETE FROM ");
        delete.append(deleteType.tableName);
        delete.append(" WHERE ");
        delete.append("YCSB_KEY");
        delete.append(" = ?;");
        PreparedStatement deleteStatement = this.getShardConnectionByKey(key).prepareStatement(delete.toString());
        PreparedStatement stmt = this.cachedStatements.putIfAbsent(deleteType, deleteStatement);
        if (stmt == null) {
            return deleteStatement;
        }
        return stmt;
    }

    private PreparedStatement createAndCacheUpdateStatement(StatementType updateType, String key) throws SQLException {
        StringBuilder update = new StringBuilder("UPDATE ");
        update.append(updateType.tableName);
        update.append(" SET ");
        for (int i = 1; i <= updateType.numFields; ++i) {
            update.append("FIELD");
            update.append(i);
            update.append("=?");
            if (i >= updateType.numFields) continue;
            update.append(", ");
        }
        update.append(" WHERE ");
        update.append("YCSB_KEY");
        update.append(" = ?;");
        PreparedStatement insertStatement = this.getShardConnectionByKey(key).prepareStatement(update.toString());
        PreparedStatement stmt = this.cachedStatements.putIfAbsent(updateType, insertStatement);
        if (stmt == null) {
            return insertStatement;
        }
        return stmt;
    }

    private PreparedStatement createAndCacheScanStatement(StatementType scanType, String key) throws SQLException {
        PreparedStatement stmt;
        StringBuilder select = new StringBuilder("SELECT * FROM ");
        select.append(scanType.tableName);
        select.append(" WHERE ");
        select.append("YCSB_KEY");
        select.append(" >= ");
        select.append("?;");
        PreparedStatement scanStatement = this.getShardConnectionByKey(key).prepareStatement(select.toString());
        if (this.jdbcFetchSize != null) {
            scanStatement.setFetchSize(this.jdbcFetchSize);
        }
        if ((stmt = this.cachedStatements.putIfAbsent(scanType, scanStatement)) == null) {
            return scanStatement;
        }
        return stmt;
    }

    public int read(String tableName, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        if (tableName == null) {
            return -1;
        }
        if (key == null) {
            return -1;
        }
        try {
            StatementType type = new StatementType(StatementType.Type.READ, tableName, 1, this.getShardIndexByKey(key));
            PreparedStatement readStatement = (PreparedStatement)this.cachedStatements.get(type);
            if (readStatement == null) {
                readStatement = this.createAndCacheReadStatement(type, key);
            }
            readStatement.setString(1, key);
            ResultSet resultSet = readStatement.executeQuery();
            if (!resultSet.next()) {
                resultSet.close();
                return 1;
            }
            if (result != null && fields != null) {
                for (String field : fields) {
                    String value = resultSet.getString(field);
                    result.put(field, (ByteIterator)new StringByteIterator(value));
                }
            }
            resultSet.close();
            return 0;
        }
        catch (SQLException e) {
            System.err.println("Error in processing read of table " + tableName + ": " + e);
            return -2;
        }
    }

    public int scan(String tableName, String startKey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        if (tableName == null) {
            return -1;
        }
        if (startKey == null) {
            return -1;
        }
        try {
            StatementType type = new StatementType(StatementType.Type.SCAN, tableName, 1, this.getShardIndexByKey(startKey));
            PreparedStatement scanStatement = (PreparedStatement)this.cachedStatements.get(type);
            if (scanStatement == null) {
                scanStatement = this.createAndCacheScanStatement(type, startKey);
            }
            scanStatement.setString(1, startKey);
            ResultSet resultSet = scanStatement.executeQuery();
            for (int i = 0; i < recordcount && resultSet.next(); ++i) {
                if (result == null || fields == null) continue;
                HashMap<String, StringByteIterator> values = new HashMap<String, StringByteIterator>();
                for (String field : fields) {
                    String value = resultSet.getString(field);
                    values.put(field, new StringByteIterator(value));
                }
                result.add(values);
            }
            resultSet.close();
            return 0;
        }
        catch (SQLException e) {
            System.err.println("Error in processing scan of table: " + tableName + e);
            return -2;
        }
    }

    public int update(String tableName, String key, HashMap<String, ByteIterator> values) {
        if (tableName == null) {
            return -1;
        }
        if (key == null) {
            return -1;
        }
        try {
            int numFields = values.size();
            StatementType type = new StatementType(StatementType.Type.UPDATE, tableName, numFields, this.getShardIndexByKey(key));
            PreparedStatement updateStatement = (PreparedStatement)this.cachedStatements.get(type);
            if (updateStatement == null) {
                updateStatement = this.createAndCacheUpdateStatement(type, key);
            }
            int index = 1;
            for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                updateStatement.setString(index++, entry.getValue().toString());
            }
            updateStatement.setString(index, key);
            int result = updateStatement.executeUpdate();
            if (result == 1) {
                return 0;
            }
            return 1;
        }
        catch (SQLException e) {
            System.err.println("Error in processing update to table: " + tableName + e);
            return -1;
        }
    }

    public int insert(String tableName, String key, HashMap<String, ByteIterator> values) {
        if (tableName == null) {
            return -1;
        }
        if (key == null) {
            return -1;
        }
        try {
            int numFields = values.size();
            StatementType type = new StatementType(StatementType.Type.INSERT, tableName, numFields, this.getShardIndexByKey(key));
            PreparedStatement insertStatement = (PreparedStatement)this.cachedStatements.get(type);
            if (insertStatement == null) {
                insertStatement = this.createAndCacheInsertStatement(type, key);
            }
            insertStatement.setString(1, key);
            int index = 2;
            for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                String field = entry.getValue().toString();
                insertStatement.setString(index++, field);
            }
            int result = insertStatement.executeUpdate();
            if (result == 1) {
                return 0;
            }
            return 1;
        }
        catch (SQLException e) {
            System.err.println("Error in processing insert to table: " + tableName + e);
            return -1;
        }
    }

    public int delete(String tableName, String key) {
        if (tableName == null) {
            return -1;
        }
        if (key == null) {
            return -1;
        }
        try {
            StatementType type = new StatementType(StatementType.Type.DELETE, tableName, 1, this.getShardIndexByKey(key));
            PreparedStatement deleteStatement = (PreparedStatement)this.cachedStatements.get(type);
            if (deleteStatement == null) {
                deleteStatement = this.createAndCacheDeleteStatement(type, key);
            }
            deleteStatement.setString(1, key);
            int result = deleteStatement.executeUpdate();
            if (result == 1) {
                return 0;
            }
            return 1;
        }
        catch (SQLException e) {
            System.err.println("Error in processing delete to table: " + tableName + e);
            return -1;
        }
    }

    private static class StatementType {
        Type type;
        int shardIndex;
        int numFields;
        String tableName;

        StatementType(Type type, String tableName, int numFields, int _shardIndex) {
            this.type = type;
            this.tableName = tableName;
            this.numFields = numFields;
            this.shardIndex = _shardIndex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.numFields + 100 * this.shardIndex;
            result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.getHashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatementType other = (StatementType)obj;
            if (this.numFields != other.numFields) {
                return false;
            }
            if (this.shardIndex != other.shardIndex) {
                return false;
            }
            if (this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName)) {
                return false;
            }
            return this.type == other.type;
        }

        static enum Type {
            INSERT(1),
            DELETE(2),
            READ(3),
            UPDATE(4),
            SCAN(5);

            int internalType;

            private Type(int type) {
                this.internalType = type;
            }

            int getHashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.internalType;
                return result;
            }
        }
    }
}

