/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

public final class Log {
    private static volatile Level gLevel = Level.INFO;
    private static volatile Callback gCallback = null;

    public static void setLevel(Level level) {
        gLevel = level;
    }

    public static void setCallback(Callback callback) {
        gCallback = callback;
    }

    public static boolean warnEnabled() {
        return gCallback != null && Level.WARN.ordinal() <= gLevel.ordinal();
    }

    public static boolean infoEnabled() {
        return gCallback != null && Level.INFO.ordinal() <= gLevel.ordinal();
    }

    public static boolean debugEnabled() {
        return gCallback != null && Level.DEBUG.ordinal() <= gLevel.ordinal();
    }

    public static void error(String message) {
        Log.log(Level.ERROR, message);
    }

    public static void warn(String message) {
        Log.log(Level.WARN, message);
    }

    public static void info(String message) {
        Log.log(Level.INFO, message);
    }

    public static void debug(String message) {
        Log.log(Level.DEBUG, message);
    }

    public static void log(Level level, String message) {
        if (gCallback != null && level.ordinal() <= gLevel.ordinal()) {
            gCallback.log(level, message);
        }
    }

    public static interface Callback {
        public void log(Level var1, String var2);
    }

    public static enum Level {
        ERROR,
        WARN,
        INFO,
        DEBUG;

    }
}

