/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.Policy;
import java.util.Arrays;
import java.util.HashSet;

public final class AsyncBatchGetArray
extends AsyncMultiCommand {
    private final BatchNode.BatchNamespace batch;
    private final Policy policy;
    private final Key[] keys;
    private final Record[] records;
    private final int readAttr;
    private int index;

    public AsyncBatchGetArray(AsyncMultiExecutor parent, AsyncCluster cluster, AsyncNode node, BatchNode.BatchNamespace batch, Policy policy, Key[] keys, HashSet<String> binNames, Record[] records, int readAttr) {
        super(parent, cluster, node, false, binNames);
        this.batch = batch;
        this.policy = policy;
        this.keys = keys;
        this.records = records;
        this.readAttr = readAttr;
    }

    @Override
    protected Policy getPolicy() {
        return this.policy;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setBatchGet(this.policy, this.keys, this.batch, this.binNames, this.readAttr);
    }

    @Override
    protected void parseRow(Key key) throws AerospikeException {
        int offset = this.batch.offsets[this.index++];
        if (Arrays.equals(key.digest, this.keys[offset].digest)) {
            if (this.resultCode == 0) {
                this.records[offset] = this.parseRecordBatch();
            }
        } else {
            throw new AerospikeException.Parse("Unexpected batch key returned: " + key.namespace + ',' + Buffer.bytesToHexString(key.digest) + ',' + this.index + ',' + offset);
        }
    }
}

