/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.async.AsyncBatchExecutor;
import com.aerospike.client.async.AsyncBatchGetArray;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.policy.BatchPolicy;
import java.util.HashSet;

public final class AsyncBatchGetArrayExecutor
extends AsyncBatchExecutor {
    private final RecordArrayListener listener;
    private final Record[] recordArray;

    public AsyncBatchGetArrayExecutor(AsyncCluster cluster, BatchPolicy policy, RecordArrayListener listener, Key[] keys, HashSet<String> binNames, int readAttr) throws AerospikeException {
        super(cluster, policy, keys);
        this.recordArray = new Record[keys.length];
        this.listener = listener;
        AsyncMultiCommand[] tasks = new AsyncBatchGetArray[this.taskSize];
        int count = 0;
        for (BatchNode batchNode : this.batchNodes) {
            for (BatchNode.BatchNamespace batchNamespace : batchNode.batchNamespaces) {
                tasks[count++] = new AsyncBatchGetArray(this, cluster, (AsyncNode)batchNode.node, batchNamespace, policy, keys, binNames, this.recordArray, readAttr);
            }
        }
        this.execute(tasks, policy.maxConcurrentThreads);
    }

    @Override
    protected void onSuccess() {
        this.listener.onSuccess(this.keys, this.recordArray);
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        this.listener.onFailure(ae);
    }
}

