/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Host;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.async.AsyncBatchExistsArrayExecutor;
import com.aerospike.client.async.AsyncBatchExistsSequenceExecutor;
import com.aerospike.client.async.AsyncBatchGetArrayExecutor;
import com.aerospike.client.async.AsyncBatchGetSequenceExecutor;
import com.aerospike.client.async.AsyncClientPolicy;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncDelete;
import com.aerospike.client.async.AsyncExecute;
import com.aerospike.client.async.AsyncExists;
import com.aerospike.client.async.AsyncOperate;
import com.aerospike.client.async.AsyncQueryExecutor;
import com.aerospike.client.async.AsyncRead;
import com.aerospike.client.async.AsyncReadHeader;
import com.aerospike.client.async.AsyncScanExecutor;
import com.aerospike.client.async.AsyncTouch;
import com.aerospike.client.async.AsyncWrite;
import com.aerospike.client.async.IAsyncClient;
import com.aerospike.client.listener.DeleteListener;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.listener.ExistsArrayListener;
import com.aerospike.client.listener.ExistsListener;
import com.aerospike.client.listener.ExistsSequenceListener;
import com.aerospike.client.listener.RecordArrayListener;
import com.aerospike.client.listener.RecordListener;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.listener.WriteListener;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Statement;
import java.util.HashSet;

public class AsyncClient
extends AerospikeClient
implements IAsyncClient {
    private final AsyncCluster cluster;
    public final Policy asyncReadPolicyDefault;
    public final WritePolicy asyncWritePolicyDefault;
    public final ScanPolicy asyncScanPolicyDefault;
    public final QueryPolicy asyncQueryPolicyDefault;
    public final BatchPolicy asyncBatchPolicyDefault;

    public AsyncClient(String hostname, int port) throws AerospikeException {
        this(new AsyncClientPolicy(), new Host(hostname, port));
    }

    public AsyncClient(AsyncClientPolicy policy, String hostname, int port) throws AerospikeException {
        this(policy, new Host(hostname, port));
    }

    public AsyncClient(AsyncClientPolicy policy, Host ... hosts) throws AerospikeException {
        super(policy);
        if (policy == null) {
            policy = new AsyncClientPolicy();
        }
        this.asyncReadPolicyDefault = policy.asyncReadPolicyDefault;
        this.asyncWritePolicyDefault = policy.asyncWritePolicyDefault;
        this.asyncScanPolicyDefault = policy.asyncScanPolicyDefault;
        this.asyncQueryPolicyDefault = policy.asyncQueryPolicyDefault;
        this.asyncBatchPolicyDefault = policy.asyncBatchPolicyDefault;
        this.cluster = new AsyncCluster(policy, hosts);
        ((AerospikeClient)this).cluster = this.cluster;
    }

    @Override
    public final void put(WritePolicy policy, WriteListener listener, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncWritePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, policy, listener, key, bins, Operation.Type.WRITE);
        command.execute();
    }

    @Override
    public final void append(WritePolicy policy, WriteListener listener, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncWritePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, policy, listener, key, bins, Operation.Type.APPEND);
        command.execute();
    }

    @Override
    public final void prepend(WritePolicy policy, WriteListener listener, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncWritePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, policy, listener, key, bins, Operation.Type.PREPEND);
        command.execute();
    }

    @Override
    public final void add(WritePolicy policy, WriteListener listener, Key key, Bin ... bins) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncWritePolicyDefault;
        }
        AsyncWrite command = new AsyncWrite(this.cluster, policy, listener, key, bins, Operation.Type.ADD);
        command.execute();
    }

    @Override
    public final void delete(WritePolicy policy, DeleteListener listener, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncWritePolicyDefault;
        }
        AsyncDelete command = new AsyncDelete(this.cluster, policy, listener, key);
        command.execute();
    }

    @Override
    public final void touch(WritePolicy policy, WriteListener listener, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncWritePolicyDefault;
        }
        AsyncTouch command = new AsyncTouch(this.cluster, policy, listener, key);
        command.execute();
    }

    @Override
    public final void exists(Policy policy, ExistsListener listener, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncReadPolicyDefault;
        }
        AsyncExists command = new AsyncExists(this.cluster, policy, listener, key);
        command.execute();
    }

    @Override
    @Deprecated
    public final void exists(Policy policy, ExistsArrayListener listener, Key[] keys) throws AerospikeException {
        BatchPolicy batchPolicy = this.getAsyncBatchPolicy(policy);
        this.exists(batchPolicy, listener, keys);
    }

    @Override
    public final void exists(BatchPolicy policy, ExistsArrayListener listener, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncBatchPolicyDefault;
        }
        new AsyncBatchExistsArrayExecutor(this.cluster, policy, keys, listener);
    }

    @Override
    @Deprecated
    public final void exists(Policy policy, ExistsSequenceListener listener, Key[] keys) throws AerospikeException {
        BatchPolicy batchPolicy = this.getAsyncBatchPolicy(policy);
        this.exists(batchPolicy, listener, keys);
    }

    @Override
    public final void exists(BatchPolicy policy, ExistsSequenceListener listener, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncBatchPolicyDefault;
        }
        new AsyncBatchExistsSequenceExecutor(this.cluster, policy, keys, listener);
    }

    @Override
    public final void get(Policy policy, RecordListener listener, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncReadPolicyDefault;
        }
        AsyncRead command = new AsyncRead(this.cluster, policy, listener, key, null);
        command.execute();
    }

    @Override
    public final void get(Policy policy, RecordListener listener, Key key, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncReadPolicyDefault;
        }
        AsyncRead command = new AsyncRead(this.cluster, policy, listener, key, binNames);
        command.execute();
    }

    @Override
    public final void getHeader(Policy policy, RecordListener listener, Key key) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncReadPolicyDefault;
        }
        AsyncReadHeader command = new AsyncReadHeader(this.cluster, policy, listener, key);
        command.execute();
    }

    @Override
    @Deprecated
    public final void get(Policy policy, RecordArrayListener listener, Key[] keys) throws AerospikeException {
        BatchPolicy batchPolicy = this.getAsyncBatchPolicy(policy);
        this.get(batchPolicy, listener, keys);
    }

    @Override
    public final void get(BatchPolicy policy, RecordArrayListener listener, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncBatchPolicyDefault;
        }
        new AsyncBatchGetArrayExecutor(this.cluster, policy, listener, keys, null, 3);
    }

    @Override
    @Deprecated
    public final void get(Policy policy, RecordSequenceListener listener, Key[] keys) throws AerospikeException {
        BatchPolicy batchPolicy = this.getAsyncBatchPolicy(policy);
        this.get(batchPolicy, listener, keys);
    }

    @Override
    public final void get(BatchPolicy policy, RecordSequenceListener listener, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncBatchPolicyDefault;
        }
        new AsyncBatchGetSequenceExecutor(this.cluster, policy, listener, keys, null, 3);
    }

    @Override
    @Deprecated
    public final void get(Policy policy, RecordArrayListener listener, Key[] keys, String ... binNames) throws AerospikeException {
        BatchPolicy batchPolicy = this.getAsyncBatchPolicy(policy);
        this.get(batchPolicy, listener, keys, binNames);
    }

    @Override
    public final void get(BatchPolicy policy, RecordArrayListener listener, Key[] keys, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncBatchPolicyDefault;
        }
        HashSet<String> names = AsyncClient.binNamesToHashSet(binNames);
        new AsyncBatchGetArrayExecutor(this.cluster, policy, listener, keys, names, 1);
    }

    @Override
    @Deprecated
    public final void get(Policy policy, RecordSequenceListener listener, Key[] keys, String ... binNames) throws AerospikeException {
        BatchPolicy batchPolicy = this.getAsyncBatchPolicy(policy);
        this.get(batchPolicy, listener, keys, binNames);
    }

    @Override
    public final void get(BatchPolicy policy, RecordSequenceListener listener, Key[] keys, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncBatchPolicyDefault;
        }
        HashSet<String> names = AsyncClient.binNamesToHashSet(binNames);
        new AsyncBatchGetSequenceExecutor(this.cluster, policy, listener, keys, names, 1);
    }

    @Override
    @Deprecated
    public final void getHeader(Policy policy, RecordArrayListener listener, Key[] keys) throws AerospikeException {
        BatchPolicy batchPolicy = this.getAsyncBatchPolicy(policy);
        this.getHeader(batchPolicy, listener, keys);
    }

    @Override
    public final void getHeader(BatchPolicy policy, RecordArrayListener listener, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncBatchPolicyDefault;
        }
        new AsyncBatchGetArrayExecutor(this.cluster, policy, listener, keys, null, 33);
    }

    @Override
    @Deprecated
    public final void getHeader(Policy policy, RecordSequenceListener listener, Key[] keys) throws AerospikeException {
        BatchPolicy batchPolicy = this.getAsyncBatchPolicy(policy);
        this.getHeader(batchPolicy, listener, keys);
    }

    @Override
    public final void getHeader(BatchPolicy policy, RecordSequenceListener listener, Key[] keys) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncBatchPolicyDefault;
        }
        new AsyncBatchGetSequenceExecutor(this.cluster, policy, listener, keys, null, 33);
    }

    @Override
    public final void operate(WritePolicy policy, RecordListener listener, Key key, Operation ... operations) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncWritePolicyDefault;
        }
        AsyncOperate command = new AsyncOperate(this.cluster, policy, listener, key, operations);
        command.execute();
    }

    @Override
    public final void scanAll(ScanPolicy policy, RecordSequenceListener listener, String namespace, String setName, String ... binNames) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncScanPolicyDefault;
        }
        new AsyncScanExecutor(this.cluster, policy, listener, namespace, setName, binNames);
    }

    @Override
    public final void execute(WritePolicy policy, ExecuteListener listener, Key key, String packageName, String functionName, Value ... functionArgs) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncWritePolicyDefault;
        }
        AsyncExecute command = new AsyncExecute(this.cluster, policy, listener, key, packageName, functionName, functionArgs);
        command.execute();
    }

    @Override
    public final void query(QueryPolicy policy, RecordSequenceListener listener, Statement statement) throws AerospikeException {
        if (policy == null) {
            policy = this.asyncQueryPolicyDefault;
        }
        new AsyncQueryExecutor(this.cluster, policy, listener, statement);
    }

    private final BatchPolicy getAsyncBatchPolicy(Policy policy) {
        if (policy == null) {
            return this.asyncBatchPolicyDefault;
        }
        BatchPolicy batchPolicy = new BatchPolicy(policy);
        batchPolicy.sleepBetweenRetries = 0;
        batchPolicy.maxConcurrentThreads = 0;
        return batchPolicy;
    }
}

