/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.async.AsyncRead;
import com.aerospike.client.listener.ExecuteListener;
import com.aerospike.client.policy.WritePolicy;
import java.util.Map;

public final class AsyncExecute
extends AsyncRead {
    private final WritePolicy writePolicy;
    private final ExecuteListener executeListener;
    private final String packageName;
    private final String functionName;
    private final Value[] args;

    public AsyncExecute(AsyncCluster cluster, WritePolicy writePolicy, ExecuteListener listener, Key key, String packageName, String functionName, Value[] args) {
        super(cluster, writePolicy, null, key, null);
        this.writePolicy = writePolicy;
        this.executeListener = listener;
        this.packageName = packageName;
        this.functionName = functionName;
        this.args = args;
    }

    @Override
    protected void writeBuffer() throws AerospikeException {
        this.setUdf(this.writePolicy, this.key, this.packageName, this.functionName, this.args);
    }

    @Override
    protected AsyncNode getNode() {
        return (AsyncNode)this.cluster.getMasterNode(this.partition);
    }

    @Override
    protected void onSuccess() {
        if (this.executeListener != null) {
            Object obj = this.parseEndResult();
            this.executeListener.onSuccess(this.key, obj);
        }
    }

    @Override
    protected void onFailure(AerospikeException e) {
        if (this.executeListener != null) {
            this.executeListener.onFailure(e);
        }
    }

    private Object parseEndResult() {
        if (this.record == null || this.record.bins == null) {
            return null;
        }
        Map<String, Object> map = this.record.bins;
        Object obj = map.get("SUCCESS");
        if (obj != null) {
            return obj;
        }
        if (map.containsKey("SUCCESS")) {
            return null;
        }
        obj = map.get("FAILURE");
        if (obj != null) {
            throw new AerospikeException(obj.toString());
        }
        throw new AerospikeException("Invalid UDF return value");
    }
}

