/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncMultiCommand;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AsyncMultiExecutor {
    private final AtomicInteger completedCount = new AtomicInteger();
    private final AtomicBoolean done = new AtomicBoolean();
    private AsyncMultiCommand[] commands;
    private int maxConcurrent;

    public void execute(AsyncMultiCommand[] commands, int maxConcurrent) {
        this.commands = commands;
        this.maxConcurrent = maxConcurrent == 0 || maxConcurrent >= commands.length ? commands.length : maxConcurrent;
        for (int i = 0; i < this.maxConcurrent; ++i) {
            commands[i].execute();
        }
    }

    protected final void childSuccess() {
        int finished = this.completedCount.incrementAndGet();
        if (finished < this.commands.length) {
            int nextThread = finished + this.maxConcurrent - 1;
            if (nextThread < this.commands.length && !this.done.get()) {
                this.commands[nextThread].execute();
            }
        } else if (this.done.compareAndSet(false, true)) {
            this.onSuccess();
        }
    }

    protected final void childFailure(AerospikeException ae) {
        if (this.done.compareAndSet(false, true)) {
            for (AsyncMultiCommand command : this.commands) {
                command.stop();
            }
            this.onFailure(ae);
        }
    }

    protected abstract void onSuccess();

    protected abstract void onFailure(AerospikeException var1);
}

