/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncConnection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.NodeValidator;
import java.util.concurrent.ArrayBlockingQueue;

public final class AsyncNode
extends Node {
    private final ArrayBlockingQueue<AsyncConnection> asyncConnQueue;

    public AsyncNode(AsyncCluster cluster, NodeValidator nv) {
        super(cluster, nv);
        this.asyncConnQueue = new ArrayBlockingQueue(cluster.getMaxCommands());
    }

    public AsyncConnection getAsyncConnection() {
        AsyncConnection conn;
        while ((conn = this.asyncConnQueue.poll()) != null) {
            if (conn.isValid()) {
                return conn;
            }
            conn.close();
        }
        return null;
    }

    public void putAsyncConnection(AsyncConnection conn) {
        if (!this.active || !this.asyncConnQueue.offer(conn)) {
            conn.close();
        }
    }

    @Override
    protected void closeConnections() {
        AsyncConnection conn;
        super.closeConnections();
        while ((conn = this.asyncConnQueue.poll()) != null) {
            conn.close();
        }
    }
}

