/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.async.AsyncCluster;
import com.aerospike.client.async.AsyncMultiCommand;
import com.aerospike.client.async.AsyncMultiExecutor;
import com.aerospike.client.async.AsyncNode;
import com.aerospike.client.async.AsyncScan;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.listener.RecordSequenceListener;
import com.aerospike.client.policy.ScanPolicy;

public final class AsyncScanExecutor
extends AsyncMultiExecutor {
    private final RecordSequenceListener listener;

    public AsyncScanExecutor(AsyncCluster cluster, ScanPolicy policy, RecordSequenceListener listener, String namespace, String setName, String[] binNames) throws AerospikeException {
        this.listener = listener;
        Node[] nodes = cluster.getNodes();
        if (nodes.length == 0) {
            throw new AerospikeException(11, "Scan failed because cluster is empty.");
        }
        long taskId = System.nanoTime();
        AsyncMultiCommand[] tasks = new AsyncScan[nodes.length];
        int count = 0;
        for (Node node : nodes) {
            tasks[count++] = new AsyncScan(this, cluster, (AsyncNode)node, policy, listener, namespace, setName, binNames, taskId);
        }
        this.execute(tasks, policy.maxConcurrentNodes);
    }

    @Override
    protected void onSuccess() {
        this.listener.onSuccess();
    }

    @Override
    protected void onFailure(AerospikeException ae) {
        this.listener.onFailure(ae);
    }
}

