/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Host;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.admin.AdminCommand;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.util.Util;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;

public final class NodeValidator {
    String name;
    Host[] aliases;
    InetSocketAddress address;
    boolean hasReplicasAll;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeValidator(Cluster cluster, Host host) throws Exception {
        int i;
        try {
            InetAddress[] addresses = InetAddress.getAllByName(host.name);
            this.aliases = new Host[addresses.length];
            for (i = 0; i < addresses.length; ++i) {
                this.aliases[i] = new Host(addresses[i].getHostAddress(), host.port);
            }
        }
        catch (UnknownHostException uhe) {
            throw new AerospikeException.Connection("Invalid host: " + host);
        }
        Exception exception = null;
        for (i = 0; i < this.aliases.length; ++i) {
            Host alias = this.aliases[i];
            try {
                InetSocketAddress address = new InetSocketAddress(alias.name, alias.port);
                Connection conn = new Connection(address, cluster.getConnectionTimeout());
                try {
                    HashMap<String, String> map;
                    String nodeName;
                    if (cluster.user != null) {
                        AdminCommand command = new AdminCommand();
                        command.authenticate(conn, cluster.user, cluster.password);
                    }
                    if ((nodeName = (map = Info.request(conn, "node", "features")).get("node")) == null) continue;
                    this.name = nodeName;
                    this.address = address;
                    this.setFeatures(map);
                    return;
                }
                finally {
                    conn.close();
                }
            }
            catch (Exception e) {
                if (Log.debugEnabled()) {
                    Log.debug("Alias " + alias + " failed: " + Util.getErrorMessage(e));
                }
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception == null) {
            throw new AerospikeException.Connection("Failed to find addresses for " + host);
        }
        throw exception;
    }

    private void setFeatures(HashMap<String, String> map) {
        try {
            String features = map.get("features");
            String replicasAll = "replicas-all";
            int replicasAllLength = replicasAll.length();
            int begin = 0;
            while (true) {
                if (features.regionMatches(begin, replicasAll, 0, replicasAllLength)) {
                    this.hasReplicasAll = true;
                } else if ((begin = features.indexOf(59, begin)) >= 0) {
                    ++begin;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

