/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Info;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import gnu.crypto.util.Base64;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PartitionParser {
    static final String PartitionGeneration = "partition-generation";
    static final String ReplicasMaster = "replicas-master";
    static final String ReplicasAll = "replicas-all";
    private HashMap<String, AtomicReferenceArray<Node>[]> map;
    private final StringBuilder sb;
    private final byte[] buffer;
    private final int partitionCount;
    private final int generation;
    private int length;
    private int offset;
    private boolean copied;

    public PartitionParser(Connection conn, Node node, HashMap<String, AtomicReferenceArray<Node>[]> map, int partitionCount, boolean requestProleReplicas) {
        this.partitionCount = partitionCount;
        this.map = map;
        String command = requestProleReplicas ? ReplicasAll : ReplicasMaster;
        Info info = new Info(conn, PartitionGeneration, command);
        this.length = info.getLength();
        if (this.length == 0) {
            throw new AerospikeException.Parse("Partition info is empty");
        }
        this.buffer = info.getBuffer();
        this.sb = new StringBuilder(32);
        this.generation = this.parseGeneration();
        if (requestProleReplicas) {
            this.parseReplicasAll(node);
        } else {
            this.parseReplicasMaster(node);
        }
    }

    public int getGeneration() {
        return this.generation;
    }

    public boolean isPartitionMapCopied() {
        return this.copied;
    }

    public HashMap<String, AtomicReferenceArray<Node>[]> getPartitionMap() {
        return this.map;
    }

    private int parseGeneration() {
        this.expectName(PartitionGeneration);
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 10) {
                String s = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                ++this.offset;
                return Integer.parseInt(s);
            }
            ++this.offset;
        }
        throw new AerospikeException.Parse("Failed to find partition-generation value");
    }

    private void parseReplicasMaster(Node node) {
        this.expectName(ReplicasMaster);
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 58) {
                byte b;
                String namespace = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (namespace.length() <= 0 || namespace.length() >= 32) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Invalid partition namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                while (this.offset < this.length && (b = this.buffer[this.offset]) != 59 && b != 10) {
                    ++this.offset;
                }
                if (this.offset == begin) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Empty partition id for namespace " + namespace + ". Response=" + response);
                }
                AtomicReferenceArray<Node>[] replicaArray = this.map.get(namespace);
                if (replicaArray == null) {
                    replicaArray = new AtomicReferenceArray[]{new AtomicReferenceArray(this.partitionCount)};
                    this.copyPartitionMap();
                    this.map.put(namespace, replicaArray);
                }
                this.decodeBitmap(node, replicaArray[0], begin);
                begin = ++this.offset;
                continue;
            }
            ++this.offset;
        }
    }

    private void parseReplicasAll(Node node) throws AerospikeException {
        this.expectName(ReplicasAll);
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 58) {
                int i;
                byte b;
                String namespace = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (namespace.length() <= 0 || namespace.length() >= 32) {
                    String response = this.getTruncatedResponse();
                    throw new AerospikeException.Parse("Invalid partition namespace " + namespace + ". Response=" + response);
                }
                begin = ++this.offset;
                while (this.offset < this.length && (b = this.buffer[this.offset]) != 44) {
                    ++this.offset;
                }
                int replicaCount = Integer.parseInt(new String(this.buffer, begin, this.offset - begin));
                AtomicReferenceArray<Node>[] replicaArray = this.map.get(namespace);
                if (replicaArray == null) {
                    replicaArray = new AtomicReferenceArray[replicaCount];
                    for (i = 0; i < replicaCount; ++i) {
                        replicaArray[i] = new AtomicReferenceArray(this.partitionCount);
                    }
                    this.copyPartitionMap();
                    this.map.put(namespace, replicaArray);
                } else if (replicaArray.length != replicaCount) {
                    int i2;
                    if (Log.infoEnabled()) {
                        Log.info("Namespace " + namespace + " replication factor changed from " + replicaArray.length + " to " + replicaCount);
                    }
                    AtomicReferenceArray[] replicaTarget = new AtomicReferenceArray[replicaCount];
                    if (replicaArray.length < replicaCount) {
                        for (i2 = 0; i2 < replicaArray.length; ++i2) {
                            replicaTarget[i2] = replicaArray[i2];
                        }
                        while (i2 < replicaCount) {
                            replicaTarget[i2] = new AtomicReferenceArray(this.partitionCount);
                            ++i2;
                        }
                    } else {
                        for (i2 = 0; i2 < replicaCount; ++i2) {
                            replicaTarget[i2] = replicaArray[i2];
                        }
                    }
                    this.copyPartitionMap();
                    replicaArray = replicaTarget;
                    this.map.put(namespace, replicaArray);
                }
                for (i = 0; i < replicaCount; ++i) {
                    byte b2;
                    begin = ++this.offset;
                    while (this.offset < this.length && (b2 = this.buffer[this.offset]) != 44 && b2 != 59) {
                        ++this.offset;
                    }
                    if (this.offset == begin) {
                        String response = this.getTruncatedResponse();
                        throw new AerospikeException.Parse("Empty partition id for namespace " + namespace + ". Response=" + response);
                    }
                    this.decodeBitmap(node, replicaArray[i], begin);
                }
                begin = ++this.offset;
                continue;
            }
            ++this.offset;
        }
    }

    private void decodeBitmap(Node node, AtomicReferenceArray<Node> nodeArray, int begin) {
        byte[] restoreBuffer = Base64.decode((byte[])this.buffer, (int)begin, (int)(this.offset - begin));
        for (int i = 0; i < this.partitionCount; ++i) {
            Node nodeOld = nodeArray.get(i);
            if ((restoreBuffer[i >> 3] & 128 >> (i & 7)) != 0) {
                if (nodeOld != null && nodeOld != node) {
                    nodeOld.partitionGeneration = -1;
                }
                nodeArray.lazySet(i, node);
                continue;
            }
            if (node != nodeOld) continue;
            nodeArray.lazySet(i, null);
        }
    }

    private void copyPartitionMap() {
        if (!this.copied) {
            this.map = new HashMap<String, AtomicReferenceArray<Node>[]>(this.map);
            this.copied = true;
        }
    }

    private void expectName(String name) throws AerospikeException {
        int begin = this.offset;
        while (this.offset < this.length) {
            if (this.buffer[this.offset] == 9) {
                String s = Buffer.utf8ToString(this.buffer, begin, this.offset - begin, this.sb).trim();
                if (!name.equals(s)) break;
                ++this.offset;
                return;
            }
            ++this.offset;
        }
        throw new AerospikeException.Parse("Failed to find " + name);
    }

    private String getTruncatedResponse() {
        int max = this.length > 200 ? 200 : this.length;
        return Buffer.utf8ToString(this.buffer, 0, max);
    }
}

