/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.Command;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.util.Util;
import java.io.IOException;

public abstract class SyncCommand
extends Command {
    public final void execute() throws AerospikeException {
        Policy policy = this.getPolicy();
        int remainingMillis = policy.timeout;
        long limit = System.currentTimeMillis() + (long)remainingMillis;
        Node node = null;
        int failedNodes = 0;
        int failedConns = 0;
        int iterations = 0;
        while (true) {
            try {
                node = this.getNode();
                Connection conn = node.getConnection(remainingMillis);
                try {
                    this.writeBuffer();
                    Buffer.intToBytes(remainingMillis, this.dataBuffer, 22);
                    conn.write(this.dataBuffer, this.dataOffset);
                    this.parseResult(conn);
                    conn.updateLastUsed();
                    node.putConnection(conn);
                    return;
                }
                catch (AerospikeException ae) {
                    if (ae.keepConnection()) {
                        conn.updateLastUsed();
                        node.putConnection(conn);
                    } else {
                        conn.close();
                    }
                    throw ae;
                }
                catch (RuntimeException re) {
                    conn.close();
                    throw re;
                }
                catch (IOException ioe) {
                    conn.close();
                    if (Log.debugEnabled()) {
                        Log.debug("Node " + node + ": " + Util.getErrorMessage(ioe));
                    }
                }
            }
            catch (AerospikeException.InvalidNode ine) {
                ++failedNodes;
            }
            catch (AerospikeException.Connection ce) {
                if (Log.debugEnabled()) {
                    Log.debug("Node " + node + ": " + Util.getErrorMessage(ce));
                }
                ++failedConns;
            }
            if (++iterations > policy.maxRetries || policy.timeout > 0 && (remainingMillis = (int)(limit - System.currentTimeMillis() - (long)policy.sleepBetweenRetries)) <= 0) break;
            if (policy.sleepBetweenRetries > 0) {
                Util.sleep(policy.sleepBetweenRetries);
            }
            node = null;
        }
        throw new AerospikeException.Timeout(node, policy.timeout, iterations, failedNodes, failedConns);
    }

    protected final void emptySocket(Connection conn) throws IOException {
        byte headerLength;
        long sz = Buffer.bytesToLong(this.dataBuffer, 0);
        int receiveSize = (int)(sz & 0xFFFFFFFFFFFFL) - (headerLength = this.dataBuffer[8]);
        if (receiveSize > 0) {
            this.sizeBuffer(receiveSize);
            conn.readFully(this.dataBuffer, receiveSize);
        }
    }

    protected abstract Node getNode() throws AerospikeException.InvalidNode;

    protected abstract void parseResult(Connection var1) throws AerospikeException, IOException;
}

