/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.large;

import com.aerospike.client.AerospikeClient;
import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.util.Util;
import java.util.List;
import java.util.Map;

public class LargeList {
    private static final String PackageName = "llist";
    private final AerospikeClient client;
    private final WritePolicy policy;
    private final Key key;
    private final Value binName;

    public LargeList(AerospikeClient client, WritePolicy policy, Key key, String binName) {
        this.client = client;
        this.policy = policy;
        this.key = key;
        this.binName = Value.get(binName);
    }

    public void add(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "add", this.binName, value);
    }

    public void add(Value ... values) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "add_all", this.binName, Value.get(values));
    }

    public void add(List<?> values) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "add_all", this.binName, Value.get(values));
    }

    public void update(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "update", this.binName, value);
    }

    public void update(Value ... values) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "update_all", this.binName, Value.get(values));
    }

    public void update(List<?> values) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "update_all", this.binName, Value.get(values));
    }

    public void remove(Value value) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "remove", this.binName, value);
    }

    public void remove(List<?> values) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "remove_all", this.binName, Value.get(values));
    }

    public int remove(Value begin, Value end) throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "remove_range", this.binName, begin, end);
        return Util.toInt(result);
    }

    public List<?> find(Value value) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find", this.binName, value);
    }

    public List<?> findThenFilter(Value value, String filterModule, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_then_filter", this.binName, value, Value.get(filterModule), Value.get(filterName), Value.get(filterArgs));
    }

    public List<?> findFirst(int count) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_first", this.binName, Value.get(count));
    }

    public List<?> findFirst(int count, String filterModule, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_first", this.binName, Value.get(count), Value.get(filterModule), Value.get(filterName), Value.get(filterArgs));
    }

    public List<?> findLast(int count) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_last", this.binName, Value.get(count));
    }

    public List<?> findLast(int count, String filterModule, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_last", this.binName, Value.get(count), Value.get(filterModule), Value.get(filterName), Value.get(filterArgs));
    }

    public List<?> findFrom(Value begin, int count) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_from", this.binName, begin, Value.get(count));
    }

    public List<?> findFrom(Value begin, int count, String filterModule, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_from", this.binName, begin, Value.get(count), Value.get(filterModule), Value.get(filterName), Value.get(filterArgs));
    }

    public List<?> range(Value begin, Value end) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "range", this.binName, begin, end);
    }

    public List<?> range(Value begin, Value end, int count) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_range", this.binName, begin, end, Value.get(count));
    }

    public List<?> range(Value begin, Value end, String filterModule, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "range", this.binName, begin, end, Value.get(filterModule), Value.get(filterModule), Value.get(filterArgs));
    }

    public List<?> range(Value begin, Value end, int count, String filterModule, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "find_range", this.binName, begin, end, Value.get(count), Value.get(filterModule), Value.get(filterName), Value.get(filterArgs));
    }

    public List<?> scan() throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "scan", this.binName);
    }

    public List<?> filter(String filterModule, String filterName, Value ... filterArgs) throws AerospikeException {
        return (List)this.client.execute(this.policy, this.key, PackageName, "filter", this.binName, Value.get(filterModule), Value.get(filterName), Value.get(filterArgs));
    }

    public void destroy() throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "destroy", this.binName);
    }

    public int size() throws AerospikeException {
        Object result = this.client.execute(this.policy, this.key, PackageName, "size", this.binName);
        return Util.toInt(result);
    }

    public Map<?, ?> getConfig() throws AerospikeException {
        return (Map)this.client.execute(this.policy, this.key, PackageName, "config", this.binName);
    }

    public void setPageSize(int pageSize) throws AerospikeException {
        this.client.execute(this.policy, this.key, PackageName, "setPageSize", this.binName, Value.get(pageSize));
    }
}

