/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.lua;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.lua.LuaConfig;
import com.aerospike.client.lua.LuaInstance;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.LuaC;

public final class LuaCache {
    private static final ArrayBlockingQueue<LuaInstance> InstanceQueue = new ArrayBlockingQueue(LuaConfig.InstancePoolSize);
    private static final ConcurrentHashMap<String, Prototype> Packages = new ConcurrentHashMap();

    public static final LuaInstance getInstance() throws AerospikeException {
        LuaInstance instance = InstanceQueue.poll();
        return instance != null ? instance : new LuaInstance();
    }

    public static final void putInstance(LuaInstance instance) {
        InstanceQueue.offer(instance);
    }

    public static final Prototype loadPackageFromFile(String packageName) throws AerospikeException {
        Prototype prototype = Packages.get(packageName);
        if (prototype == null) {
            File source = new File(LuaConfig.SourceDirectory, packageName + ".lua");
            try {
                FileInputStream is = new FileInputStream(source);
                prototype = LuaCache.compile(packageName, is);
                Packages.put(packageName, prototype);
            }
            catch (Exception e) {
                throw new AerospikeException("Failed to read file: " + source.getAbsolutePath());
            }
        }
        return prototype;
    }

    public static final Prototype loadPackageFromResource(ClassLoader resourceLoader, String resourcePath, String packageName) throws AerospikeException {
        Prototype prototype = Packages.get(packageName);
        if (prototype == null) {
            try {
                InputStream is = resourceLoader.getResourceAsStream(resourcePath);
                if (is == null) {
                    throw new Exception();
                }
                prototype = LuaCache.compile(packageName, is);
                Packages.put(packageName, prototype);
            }
            catch (Exception e) {
                throw new AerospikeException("Failed to read resource: " + resourcePath);
            }
        }
        return prototype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Prototype compile(String packageName, InputStream is) throws AerospikeException {
        Prototype prototype;
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            prototype = LuaC.instance.compile((InputStream)bis, packageName);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new AerospikeException("Failed to compile: " + packageName);
            }
        }
        is.close();
        return prototype;
    }

    public static final void clearPackages() {
        Packages.clear();
    }
}

