/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.query.QueryAggregateExecutor;
import java.io.Closeable;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public final class ResultSet
implements Iterable<Object>,
Closeable {
    public static final Integer END = new Integer(-1);
    private final QueryAggregateExecutor executor;
    private final BlockingQueue<Object> queue;
    private Object row;
    private volatile boolean valid = true;

    protected ResultSet(QueryAggregateExecutor executor, int capacity) {
        this.executor = executor;
        this.queue = new ArrayBlockingQueue<Object>(capacity);
    }

    public final boolean next() throws AerospikeException {
        if (!this.valid) {
            this.executor.checkForException();
            return false;
        }
        try {
            this.row = this.queue.take();
        }
        catch (InterruptedException ie) {
            this.valid = false;
            if (Log.debugEnabled()) {
                Log.debug("ResultSet " + this.executor.statement.taskId + " take interrupted");
            }
            return false;
        }
        if (this.row == END) {
            this.valid = false;
            this.executor.checkForException();
            return false;
        }
        return true;
    }

    @Override
    public final void close() {
        this.valid = false;
        if (this.row != END && this.queue.poll() != END) {
            this.executor.stopThreads(new AerospikeException.QueryTerminated());
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return new ResultSetIterator(this);
    }

    public final Object getObject() {
        return this.row;
    }

    public final boolean put(Object object) {
        if (!this.valid) {
            return false;
        }
        try {
            this.queue.put(object);
            return true;
        }
        catch (InterruptedException ie) {
            if (Log.debugEnabled()) {
                Log.debug("ResultSet " + this.executor.statement.taskId + " put interrupted");
            }
            if (this.valid) {
                this.abort();
            }
            return false;
        }
    }

    protected final void abort() {
        this.valid = false;
        this.queue.clear();
        while (!this.queue.offer(END)) {
            if (this.queue.poll() != null) continue;
            if (!Log.debugEnabled()) break;
            Log.debug("ResultSet " + this.executor.statement.taskId + " both offer and poll failed on abort");
            break;
        }
    }

    private class ResultSetIterator
    implements Iterator<Object>,
    Closeable {
        private final ResultSet resultSet;

        ResultSetIterator(ResultSet resultSet2) {
            this.resultSet = resultSet2;
        }

        @Override
        public boolean hasNext() {
            return this.resultSet.next();
        }

        @Override
        public Object next() {
            return this.resultSet.row;
        }

        @Override
        public void remove() {
        }

        @Override
        public void close() {
            this.resultSet.close();
        }
    }
}

