/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.tarantool.AsyncQuery;
import org.tarantool.Code;
import org.tarantool.CommunicationException;
import org.tarantool.ConnectionState;
import org.tarantool.Key;
import org.tarantool.TarantoolAsyncConnection16;
import org.tarantool.TarantoolConnection16Impl;
import org.tarantool.TarantoolException;
import org.tarantool.TarantoolSelectorWorker;

public class TarantoolAsyncConnection16Impl
implements TarantoolSelectorWorker.ChannelProcessor,
TarantoolAsyncConnection16 {
    protected static final int ST_LENGTH = 0;
    protected static final int ST_BODY = 1;
    protected volatile SelectionKey key;
    protected volatile SocketChannel channel;
    protected AtomicLong syncId = new AtomicLong(0L);
    protected final ConnectionState readState = new ConnectionState();
    protected ByteBuffer readBuffer;
    protected final ConnectionState writeState = new ConnectionState();
    protected ByteBuffer writeBuffer;
    protected LinkedBlockingQueue<AsyncQuery> writeQueue = new LinkedBlockingQueue();
    protected Map<Long, AsyncQuery> futures = new ConcurrentHashMap<Long, AsyncQuery>();
    protected int state = 0;
    protected volatile Exception error;

    public TarantoolAsyncConnection16Impl(TarantoolSelectorWorker worker, SocketChannel channel, String username, String password, long timeout, TimeUnit unit) {
        TarantoolConnection16Impl connection = new TarantoolConnection16Impl(channel);
        if (username != null) {
            connection.auth(username, password);
        }
        BlockingQueue<SelectionKey> queue = worker.register(connection.getChannel(), this);
        try {
            this.key = queue == null ? null : queue.poll(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new CommunicationException("Can't register key", e);
        }
        if (this.key == null) {
            connection.close();
            throw new CommunicationException("Can't register key");
        }
        this.channel = channel;
        this.readBuffer = this.readState.getLengthReadBuffer();
    }

    @Override
    public void idle() {
        this.key.interestOps(1 | (this.writeQueue.isEmpty() ? 0 : 4));
    }

    @Override
    public void read() {
        try {
            int read = this.channel.read(this.readBuffer);
            if (read < 0) {
                this.close(new ClosedChannelException());
            }
            if (read > 0 && this.readBuffer.position() == this.readBuffer.limit()) {
                if (this.state == 0) {
                    this.readBuffer = this.readState.getPacketReadBuffer();
                    this.state = 1;
                    this.read();
                } else if (this.state == 1) {
                    this.readState.unpack();
                    long code = (Long)this.readState.getHeader().get(Key.CODE);
                    long syncId = (Long)this.readState.getHeader().get(Key.SYNC);
                    AsyncQuery q = this.futures.remove(syncId);
                    if (q != null) {
                        if (code != 0L) {
                            Object error = this.readState.getBody().get(Key.ERROR);
                            q.setError(new TarantoolException((int)code, error instanceof String ? (String)error : new String((byte[])error)));
                        } else {
                            q.setValue(this.readState.getBody().get(Key.DATA));
                        }
                    }
                    this.readBuffer = this.readState.getLengthReadBuffer();
                    this.state = 0;
                }
            }
        }
        catch (IOException e) {
            this.close(e);
        }
    }

    @Override
    public void write() {
        if (this.writeBuffer == null) {
            AsyncQuery query = this.writeQueue.poll();
            try {
                if (query != null) {
                    this.writeBuffer = this.writeState.pack(query.code, query.id, query.args);
                }
            }
            catch (Exception e) {
                query.setError(e);
            }
        }
        if (this.writeBuffer != null) {
            try {
                this.channel.write(this.writeBuffer);
                if (this.writeBuffer.remaining() == 0) {
                    this.writeBuffer = null;
                }
            }
            catch (IOException e) {
                this.close(e);
            }
        }
    }

    protected Future<List> exec(Code code, Object ... args) {
        if (this.key.isValid()) {
            AsyncQuery<List> q = new AsyncQuery<List>(this.syncId.incrementAndGet(), code, args);
            this.futures.put(q.id, q);
            this.writeQueue.add(q);
            if (this.key.isValid()) {
                this.key.selector().wakeup();
                return q;
            }
            q.setError(this.error);
        }
        throw new CommunicationException("Key is cancelled", this.error);
    }

    @Override
    public Future<List> select(int space, int index, Object key, int offset, int limit, int iterator) {
        return this.exec(Code.SELECT, Key.SPACE, space, Key.INDEX, index, Key.KEY, key, Key.ITERATOR, iterator, Key.LIMIT, limit);
    }

    @Override
    public Future<List> insert(int space, Object tuple) {
        return this.exec(Code.INSERT, Key.SPACE, space, Key.TUPLE, tuple);
    }

    @Override
    public Future<List> replace(int space, Object tuple) {
        return this.exec(Code.REPLACE, Key.SPACE, space, Key.TUPLE, tuple);
    }

    @Override
    public Future<List> update(int space, Object key, Object ... args) {
        return this.exec(Code.UPDATE, Key.SPACE, space, Key.KEY, key, Key.TUPLE, args);
    }

    @Override
    public Future<List> delete(int space, Object key) {
        return this.exec(Code.DELETE, Key.SPACE, space, Key.KEY, key);
    }

    @Override
    public Future<List> call(String function, Object ... args) {
        return this.exec(Code.CALL, Key.FUNCTION, function, Key.TUPLE, args);
    }

    @Override
    public Future<List> eval(String expression, Object ... args) {
        return this.exec(Code.EVAL, Key.EXPRESSION, expression, Key.TUPLE, args);
    }

    @Override
    public void close() {
        this.close(null);
    }

    @Override
    public void close(Exception e) {
        this.error = e;
        try {
            if (this.key != null) {
                this.key.cancel();
            }
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (AsyncQuery q : this.futures.values()) {
            q.setError(this.error);
        }
    }
}

