/*
 * Decompiled with CFR 0.152.
 */
package org.tarantool;

import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.tarantool.Code;
import org.tarantool.Key;
import org.tarantool.TarantoolBatchConnection16;
import org.tarantool.TarantoolConnection16Base;

public class TarantoolBatchConnection16Impl
extends TarantoolConnection16Base
implements TarantoolBatchConnection16 {
    protected final AtomicLong syncId = new AtomicLong(0L);
    protected Map<Long, Q> batch;
    protected boolean sent = false;

    @Override
    public void begin() {
        this.batch = new LinkedHashMap<Long, Q>();
    }

    @Override
    public void end() {
        for (Map.Entry<Long, Q> entry : this.batch.entrySet()) {
            Q q = entry.getValue();
            this.write(this.state.pack(q.code, entry.getKey(), q.args));
        }
        this.sent = true;
    }

    @Override
    public void get() {
        if (!this.sent) {
            throw new IllegalStateException("Batch is not sent you should end it first");
        }
        while (!this.batch.isEmpty()) {
            this.readPacket();
            Long syncId = (Long)this.state.getHeader().get(Key.SYNC);
            Q q = this.batch.remove(syncId);
            q.result.addAll((List)this.state.getBody().get(Key.DATA));
        }
        this.batch = null;
        this.sent = false;
    }

    public TarantoolBatchConnection16Impl(SocketChannel channel) {
        super(channel);
    }

    @Override
    protected List exec(Code code, Object ... args) {
        if (this.batch == null) {
            this.write(this.state.pack(code, args));
            return (List)this.read();
        }
        if (this.sent) {
            throw new IllegalStateException("Batch is already sent. Call get to read it");
        }
        ArrayList result = new ArrayList();
        this.batch.put(this.syncId.incrementAndGet(), new Q(code, args, result));
        return result;
    }

    private static class Q {
        Code code;
        Object[] args;
        List result;

        public Q(Code code, Object[] args, List result) {
            this.code = code;
            this.args = args;
            this.result = result;
        }
    }
}

