/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Query;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class CassandraCQLClient
extends DB {
    private static Cluster cluster = null;
    private static Session session = null;
    private static ConsistencyLevel readConsistencyLevel = ConsistencyLevel.ONE;
    private static ConsistencyLevel writeConsistencyLevel = ConsistencyLevel.ONE;
    public static final int OK = 0;
    public static final int ERR = -1;
    public static final String YCSB_KEY = "y_id";
    public static final String KEYSPACE_PROPERTY = "cassandra.keyspace";
    public static final String KEYSPACE_PROPERTY_DEFAULT = "ycsb";
    public static final String USERNAME_PROPERTY = "cassandra.username";
    public static final String PASSWORD_PROPERTY = "cassandra.password";
    public static final String READ_CONSISTENCY_LEVEL_PROPERTY = "cassandra.readconsistencylevel";
    public static final String READ_CONSISTENCY_LEVEL_PROPERTY_DEFAULT = "ONE";
    public static final String WRITE_CONSISTENCY_LEVEL_PROPERTY = "cassandra.writeconsistencylevel";
    public static final String WRITE_CONSISTENCY_LEVEL_PROPERTY_DEFAULT = "ONE";
    private static final AtomicInteger initCount = new AtomicInteger(0);
    private static boolean _debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws DBException {
        initCount.incrementAndGet();
        AtomicInteger atomicInteger = initCount;
        synchronized (atomicInteger) {
            if (cluster != null) {
                return;
            }
            try {
                _debug = Boolean.parseBoolean(this.getProperties().getProperty("debug", "false"));
                String host = this.getProperties().getProperty("host");
                if (host == null) {
                    throw new DBException("Required property \"host\" missing for CassandraClient");
                }
                String[] hosts = host.split(" ");
                String port = this.getProperties().getProperty("port", "9160");
                if (port == null) {
                    throw new DBException("Required property \"port\" missing for CassandraClient");
                }
                String username = this.getProperties().getProperty(USERNAME_PROPERTY);
                String password = this.getProperties().getProperty(PASSWORD_PROPERTY);
                String keyspace = this.getProperties().getProperty(KEYSPACE_PROPERTY, KEYSPACE_PROPERTY_DEFAULT);
                readConsistencyLevel = ConsistencyLevel.valueOf((String)this.getProperties().getProperty(READ_CONSISTENCY_LEVEL_PROPERTY, "ONE"));
                writeConsistencyLevel = ConsistencyLevel.valueOf((String)this.getProperties().getProperty(WRITE_CONSISTENCY_LEVEL_PROPERTY, "ONE"));
                cluster = username != null && !username.isEmpty() ? Cluster.builder().withCredentials(username, password).withPort(Integer.valueOf(port).intValue()).addContactPoints(hosts).build() : Cluster.builder().withPort(Integer.valueOf(port).intValue()).addContactPoints(hosts).build();
                int threadcount = Integer.parseInt(this.getProperties().getProperty("threadcount", "1"));
                cluster.getConfiguration().getPoolingOptions().setMaxConnectionsPerHost(HostDistance.LOCAL, threadcount);
                cluster.getConfiguration().getSocketOptions().setConnectTimeoutMillis(180000);
                cluster.getConfiguration().getSocketOptions().setReadTimeoutMillis(180000);
                Metadata metadata = cluster.getMetadata();
                System.out.printf("Connected to cluster: %s\n", metadata.getClusterName());
                for (Host discoveredHost : metadata.getAllHosts()) {
                    System.out.printf("Datacenter: %s; Host: %s; Rack: %s\n", discoveredHost.getDatacenter(), discoveredHost.getAddress(), discoveredHost.getRack());
                }
                session = cluster.connect(keyspace);
            }
            catch (Exception e) {
                throw new DBException((Throwable)e);
            }
        }
    }

    public void cleanup() throws DBException {
        if (initCount.decrementAndGet() <= 0) {
            cluster.shutdown();
        }
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        try {
            ResultSet rs;
            Select.Selection selectBuilder;
            if (fields == null) {
                selectBuilder = QueryBuilder.select().all();
            } else {
                selectBuilder = QueryBuilder.select();
                for (String col : fields) {
                    selectBuilder.column(col);
                }
            }
            Select stmt = selectBuilder.from(table).where(QueryBuilder.eq((String)YCSB_KEY, (Object)key)).limit(1);
            stmt.setConsistencyLevel(readConsistencyLevel);
            if (_debug) {
                System.out.println(stmt.toString());
            }
            if (!(rs = session.execute((Query)stmt)).isExhausted()) {
                Row row = rs.one();
                ColumnDefinitions cd = row.getColumnDefinitions();
                for (ColumnDefinitions.Definition def : cd) {
                    ByteBuffer val = row.getBytesUnsafe(def.getName());
                    if (val != null) {
                        result.put(def.getName(), (ByteIterator)new ByteArrayByteIterator(val.array()));
                        continue;
                    }
                    result.put(def.getName(), null);
                }
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error reading key: " + key);
            return -1;
        }
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        try {
            Select.Selection selectBuilder;
            if (fields == null) {
                selectBuilder = QueryBuilder.select().all();
            } else {
                selectBuilder = QueryBuilder.select();
                for (String col : fields) {
                    selectBuilder.column(col);
                }
            }
            Select stmt = selectBuilder.from(table);
            String initialStmt = stmt.toString();
            StringBuilder scanStmt = new StringBuilder();
            scanStmt.append(initialStmt.substring(0, initialStmt.length() - 1));
            scanStmt.append(" WHERE ");
            scanStmt.append(QueryBuilder.token((String)YCSB_KEY));
            scanStmt.append(" >= ");
            scanStmt.append("token('");
            scanStmt.append(startkey);
            scanStmt.append("')");
            scanStmt.append(" LIMIT ");
            scanStmt.append(recordcount);
            stmt = new SimpleStatement(scanStmt.toString());
            stmt.setConsistencyLevel(readConsistencyLevel);
            if (_debug) {
                System.out.println(stmt.toString());
            }
            ResultSet rs = session.execute((Query)stmt);
            while (!rs.isExhausted()) {
                Row row = rs.one();
                HashMap<String, ByteArrayByteIterator> tuple = new HashMap<String, ByteArrayByteIterator>();
                ColumnDefinitions cd = row.getColumnDefinitions();
                for (ColumnDefinitions.Definition def : cd) {
                    ByteBuffer val = row.getBytesUnsafe(def.getName());
                    if (val != null) {
                        tuple.put(def.getName(), new ByteArrayByteIterator(val.array()));
                        continue;
                    }
                    tuple.put(def.getName(), null);
                }
                result.add(tuple);
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error scanning with startkey: " + startkey);
            return -1;
        }
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        return this.insert(table, key, values);
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        try {
            Insert insertStmt = QueryBuilder.insertInto((String)table);
            insertStmt.value(YCSB_KEY, (Object)key);
            for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                ByteIterator byteIterator = entry.getValue();
                String value = byteIterator.toString();
                insertStmt.value(entry.getKey(), (Object)value);
            }
            insertStmt.setConsistencyLevel(writeConsistencyLevel);
            if (_debug) {
                System.out.println(insertStmt.toString());
            }
            ResultSet rs = session.execute((Query)insertStmt);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int delete(String table, String key) {
        try {
            Delete.Where stmt = QueryBuilder.delete().from(table).where(QueryBuilder.eq((String)YCSB_KEY, (Object)key));
            stmt.setConsistencyLevel(writeConsistencyLevel);
            if (_debug) {
                System.out.println(stmt.toString());
            }
            ResultSet rs = session.execute((Query)stmt);
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error deleting key: " + key);
            return -1;
        }
    }
}

