/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Iterator;
import java.util.List;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.util.RuntimeExceptionTranslator;

public class DelegatingExtent
implements Extent {
    private final Extent _extent;
    private final DelegatingExtent _del;
    private final RuntimeExceptionTranslator _trans;

    public DelegatingExtent(Extent extent) {
        this(extent, null);
    }

    public DelegatingExtent(Extent extent, RuntimeExceptionTranslator trans) {
        this._extent = extent;
        this._del = extent instanceof DelegatingExtent ? (DelegatingExtent)extent : null;
        this._trans = trans;
    }

    public Extent getDelegate() {
        return this._extent;
    }

    public Extent getInnermostDelegate() {
        return this._del == null ? this._extent : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingExtent) {
            other = ((DelegatingExtent)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    protected RuntimeException translate(RuntimeException re) {
        return this._trans == null ? re : this._trans.translate(re);
    }

    @Override
    public Class getElementType() {
        try {
            return this._extent.getElementType();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean hasSubclasses() {
        try {
            return this._extent.hasSubclasses();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Broker getBroker() {
        try {
            return this._extent.getBroker();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public FetchConfiguration getFetchConfiguration() {
        try {
            return this._extent.getFetchConfiguration();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public boolean getIgnoreChanges() {
        try {
            return this._extent.getIgnoreChanges();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void setIgnoreChanges(boolean ignoreCache) {
        try {
            this._extent.setIgnoreChanges(ignoreCache);
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public List list() {
        try {
            return this._extent.list();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public Iterator iterator() {
        try {
            return this._extent.iterator();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void closeAll() {
        try {
            this._extent.closeAll();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void lock() {
        try {
            this._extent.lock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }

    @Override
    public void unlock() {
        try {
            this._extent.unlock();
        }
        catch (RuntimeException re) {
            throw this.translate(re);
        }
    }
}

