/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.generator;

import com.yahoo.ycsb.generator.CounterGenerator;
import java.util.concurrent.locks.ReentrantLock;

public class AcknowledgedCounterGenerator
extends CounterGenerator {
    static final int WINDOW_SIZE = Integer.rotateLeft(1, 20);
    private static final int WINDOW_MASK = WINDOW_SIZE - 1;
    private final ReentrantLock lock = new ReentrantLock();
    private final boolean[] window = new boolean[WINDOW_SIZE];
    private volatile int limit;

    public AcknowledgedCounterGenerator(int countstart) {
        super(countstart);
        this.limit = countstart - 1;
    }

    @Override
    public int lastInt() {
        return this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(int value) {
        int currentSlot = value & WINDOW_MASK;
        if (this.window[currentSlot]) {
            throw new RuntimeException("Too many unacknowledged insertion keys.");
        }
        this.window[currentSlot] = true;
        if (this.lock.tryLock()) {
            try {
                int slot;
                int index;
                int beforeFirstSlot = this.limit & WINDOW_MASK;
                for (index = this.limit + 1; index != beforeFirstSlot && this.window[slot = index & WINDOW_MASK]; ++index) {
                    this.window[slot] = false;
                }
                this.limit = index - 1;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

