/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.generator;

import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.generator.IntegerGenerator;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class HistogramGenerator
extends IntegerGenerator {
    long block_size;
    long[] buckets;
    long area;
    long weighted_area = 0L;
    double mean_size = 0.0;

    public HistogramGenerator(String histogramfile) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(histogramfile));
        ArrayList<Integer> a = new ArrayList<Integer>();
        String str = in.readLine();
        if (str == null) {
            throw new IOException("Empty input file!\n");
        }
        String[] line = str.split("\t");
        if (line[0].compareTo("BlockSize") != 0) {
            throw new IOException("First line of histogram is not the BlockSize!\n");
        }
        this.block_size = Integer.parseInt(line[1]);
        while ((str = in.readLine()) != null) {
            line = str.split("\t");
            a.add(Integer.parseInt(line[0]), Integer.parseInt(line[1]));
        }
        this.buckets = new long[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            this.buckets[i] = ((Integer)a.get(i)).intValue();
        }
        in.close();
        this.init();
    }

    public HistogramGenerator(long[] buckets, int block_size) {
        this.block_size = block_size;
        this.buckets = buckets;
        this.init();
    }

    private void init() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.area += this.buckets[i];
            this.weighted_area = (long)i * this.buckets[i];
        }
        this.mean_size = (double)this.block_size * (double)this.weighted_area / (double)this.area;
    }

    @Override
    public int nextInt() {
        int i;
        int number = Utils.random().nextInt((int)this.area);
        for (i = 0; i < this.buckets.length - 1; ++i) {
            if ((number = (int)((long)number - this.buckets[i])) > 0) continue;
            return (int)((long)(i + 1) * this.block_size);
        }
        return (int)((long)i * this.block_size);
    }

    @Override
    public double mean() {
        return this.mean_size;
    }
}

