/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.measurements;

import com.yahoo.ycsb.measurements.OneMeasurement;
import com.yahoo.ycsb.measurements.OneMeasurementHdrHistogram;
import com.yahoo.ycsb.measurements.OneMeasurementHistogram;
import com.yahoo.ycsb.measurements.OneMeasurementTimeSeries;
import com.yahoo.ycsb.measurements.TwoInOneMeasurement;
import com.yahoo.ycsb.measurements.exporter.MeasurementsExporter;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class Measurements {
    public static final String MEASUREMENT_TYPE_PROPERTY = "measurementtype";
    private static final String MEASUREMENT_TYPE_PROPERTY_DEFAULT = "hdrhistogram";
    public static final String MEASUREMENT_INTERVAL = "measurement.interval";
    private static final String MEASUREMENT_INTERVAL_DEFAULT = "op";
    static Measurements singleton = null;
    static Properties measurementproperties = null;
    final ConcurrentHashMap<String, OneMeasurement> _opToMesurementMap;
    final ConcurrentHashMap<String, OneMeasurement> _opToIntendedMesurementMap;
    final int _measurementType;
    final int _measurementInterval;
    private Properties _props;
    ThreadLocal<StartTimeHolder> tlIntendedStartTime = new ThreadLocal<StartTimeHolder>(){

        @Override
        protected StartTimeHolder initialValue() {
            return new StartTimeHolder();
        }
    };

    public static void setProperties(Properties props) {
        measurementproperties = props;
    }

    public static synchronized Measurements getMeasurements() {
        if (singleton == null) {
            singleton = new Measurements(measurementproperties);
        }
        return singleton;
    }

    public Measurements(Properties props) {
        this._opToMesurementMap = new ConcurrentHashMap();
        this._opToIntendedMesurementMap = new ConcurrentHashMap();
        this._props = props;
        String mTypeString = this._props.getProperty(MEASUREMENT_TYPE_PROPERTY, MEASUREMENT_TYPE_PROPERTY_DEFAULT);
        if (mTypeString.equals("histogram")) {
            this._measurementType = 0;
        } else if (mTypeString.equals(MEASUREMENT_TYPE_PROPERTY_DEFAULT)) {
            this._measurementType = 1;
        } else if (mTypeString.equals("hdrhistogram+histogram")) {
            this._measurementType = 2;
        } else if (mTypeString.equals("timeseries")) {
            this._measurementType = 3;
        } else {
            throw new IllegalArgumentException("unknown measurementtype=" + mTypeString);
        }
        String mIntervalString = this._props.getProperty(MEASUREMENT_INTERVAL, MEASUREMENT_INTERVAL_DEFAULT);
        if (mIntervalString.equals(MEASUREMENT_INTERVAL_DEFAULT)) {
            this._measurementInterval = 0;
        } else if (mIntervalString.equals("intended")) {
            this._measurementInterval = 1;
        } else if (mIntervalString.equals("both")) {
            this._measurementInterval = 2;
        } else {
            throw new IllegalArgumentException("unknown measurement.interval=" + mIntervalString);
        }
    }

    OneMeasurement constructOneMeasurement(String name) {
        switch (this._measurementType) {
            case 0: {
                return new OneMeasurementHistogram(name, this._props);
            }
            case 1: {
                return new OneMeasurementHdrHistogram(name, this._props);
            }
            case 2: {
                return new TwoInOneMeasurement(name, new OneMeasurementHdrHistogram("Hdr" + name, this._props), new OneMeasurementHistogram("Bucket" + name, this._props));
            }
        }
        return new OneMeasurementTimeSeries(name, this._props);
    }

    public void setIntendedStartTimeNs(long time) {
        if (this._measurementInterval == 0) {
            return;
        }
        this.tlIntendedStartTime.get().time = time;
    }

    public long getIntendedtartTimeNs() {
        if (this._measurementInterval == 0) {
            return 0L;
        }
        return this.tlIntendedStartTime.get().startTime();
    }

    public void measure(String operation, int latency) {
        if (this._measurementInterval == 1) {
            return;
        }
        try {
            OneMeasurement m = this.getOpMeasurement(operation);
            m.measure(latency);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ERROR: java.lang.ArrayIndexOutOfBoundsException - ignoring and continuing");
            e.printStackTrace();
            e.printStackTrace(System.out);
        }
    }

    public void measureIntended(String operation, int latency) {
        if (this._measurementInterval == 0) {
            return;
        }
        try {
            OneMeasurement m = this.getOpIntendedMeasurement(operation);
            m.measure(latency);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ERROR: java.lang.ArrayIndexOutOfBoundsException - ignoring and continuing");
            e.printStackTrace();
            e.printStackTrace(System.out);
        }
    }

    private OneMeasurement getOpMeasurement(String operation) {
        OneMeasurement oldM;
        OneMeasurement m = this._opToMesurementMap.get(operation);
        if (m == null && (oldM = this._opToMesurementMap.putIfAbsent(operation, m = this.constructOneMeasurement(operation))) != null) {
            m = oldM;
        }
        return m;
    }

    private OneMeasurement getOpIntendedMeasurement(String operation) {
        String name;
        OneMeasurement oldM;
        OneMeasurement m = this._opToIntendedMesurementMap.get(operation);
        if (m == null && (oldM = this._opToIntendedMesurementMap.putIfAbsent(operation, m = this.constructOneMeasurement(name = this._measurementInterval == 1 ? operation : "Intended-" + operation))) != null) {
            m = oldM;
        }
        return m;
    }

    public void reportReturnCode(String operation, int code) {
        OneMeasurement m = this._measurementInterval == 1 ? this.getOpIntendedMeasurement(operation) : this.getOpMeasurement(operation);
        m.reportReturnCode(code);
    }

    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        for (OneMeasurement measurement : this._opToMesurementMap.values()) {
            measurement.exportMeasurements(exporter);
        }
        for (OneMeasurement measurement : this._opToIntendedMesurementMap.values()) {
            measurement.exportMeasurements(exporter);
        }
    }

    public synchronized String getSummary() {
        String ret = "";
        for (OneMeasurement m : this._opToMesurementMap.values()) {
            ret = ret + m.getSummary() + " ";
        }
        for (OneMeasurement m : this._opToIntendedMesurementMap.values()) {
            ret = ret + m.getSummary() + " ";
        }
        return ret;
    }

    static class StartTimeHolder {
        long time;

        StartTimeHolder() {
        }

        long startTime() {
            if (this.time == 0L) {
                return System.nanoTime();
            }
            return this.time;
        }
    }
}

