/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.measurements;

import com.yahoo.ycsb.measurements.exporter.MeasurementsExporter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class OneMeasurement {
    private final String _name;
    private final ConcurrentHashMap<Integer, AtomicInteger> _returncodes;

    public String getName() {
        return this._name;
    }

    public OneMeasurement(String _name) {
        this._name = _name;
        this._returncodes = new ConcurrentHashMap();
    }

    public abstract void measure(int var1);

    public abstract String getSummary();

    public void reportReturnCode(int code) {
        AtomicInteger other;
        Integer Icode = code;
        AtomicInteger counter = this._returncodes.get(Icode);
        if (counter == null && (other = this._returncodes.putIfAbsent(Icode, counter = new AtomicInteger())) != null) {
            counter = other;
        }
        counter.incrementAndGet();
    }

    public abstract void exportMeasurements(MeasurementsExporter var1) throws IOException;

    protected final void exportReturnCodes(MeasurementsExporter exporter) throws IOException {
        for (Map.Entry<Integer, AtomicInteger> entry : this._returncodes.entrySet()) {
            exporter.write(this.getName(), "Return=" + entry.getKey(), entry.getValue().get());
        }
    }
}

