/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.measurements;

import com.yahoo.ycsb.measurements.OneMeasurement;
import com.yahoo.ycsb.measurements.SeriesUnit;
import com.yahoo.ycsb.measurements.exporter.MeasurementsExporter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.Vector;

public class OneMeasurementTimeSeries
extends OneMeasurement {
    public static final String GRANULARITY = "timeseries.granularity";
    public static final String GRANULARITY_DEFAULT = "1000";
    int _granularity;
    Vector<SeriesUnit> _measurements;
    long start = -1L;
    long currentunit = -1L;
    int count = 0;
    int sum = 0;
    int operations = 0;
    long totallatency = 0L;
    int windowoperations = 0;
    long windowtotallatency = 0L;
    int min = -1;
    int max = -1;

    public OneMeasurementTimeSeries(String name, Properties props) {
        super(name);
        this._granularity = Integer.parseInt(props.getProperty(GRANULARITY, GRANULARITY_DEFAULT));
        this._measurements = new Vector();
    }

    void checkEndOfUnit(boolean forceend) {
        long unit;
        long now = System.currentTimeMillis();
        if (this.start < 0L) {
            this.currentunit = 0L;
            this.start = now;
        }
        if ((unit = (now - this.start) / (long)this._granularity * (long)this._granularity) > this.currentunit || forceend) {
            double avg = (double)this.sum / (double)this.count;
            this._measurements.add(new SeriesUnit(this.currentunit, avg));
            this.currentunit = unit;
            this.count = 0;
            this.sum = 0;
        }
    }

    @Override
    public void measure(int latency) {
        this.checkEndOfUnit(false);
        ++this.count;
        this.sum += latency;
        this.totallatency += (long)latency;
        ++this.operations;
        ++this.windowoperations;
        this.windowtotallatency += (long)latency;
        if (latency > this.max) {
            this.max = latency;
        }
        if (latency < this.min || this.min < 0) {
            this.min = latency;
        }
    }

    @Override
    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        this.checkEndOfUnit(true);
        exporter.write(this.getName(), "Operations", this.operations);
        exporter.write(this.getName(), "AverageLatency(us)", (double)this.totallatency / (double)this.operations);
        exporter.write(this.getName(), "MinLatency(us)", this.min);
        exporter.write(this.getName(), "MaxLatency(us)", this.max);
        this.exportReturnCodes(exporter);
        for (SeriesUnit unit : this._measurements) {
            exporter.write(this.getName(), Long.toString(unit.time), unit.average);
        }
    }

    @Override
    public String getSummary() {
        if (this.windowoperations == 0) {
            return "";
        }
        DecimalFormat d = new DecimalFormat("#.##");
        double report = (double)this.windowtotallatency / (double)this.windowoperations;
        this.windowtotallatency = 0L;
        this.windowoperations = 0;
        return "[" + this.getName() + " AverageLatency(us)=" + d.format(report) + "]";
    }
}

