/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.workloads;

import com.yahoo.ycsb.WorkloadException;
import com.yahoo.ycsb.generator.IntegerGenerator;
import com.yahoo.ycsb.workloads.CoreWorkload;
import java.util.Properties;

public class ConstantOccupancyWorkload
extends CoreWorkload {
    long disksize;
    long storageages;
    IntegerGenerator objectsizes;
    double occupancy;
    long object_count;
    public static final String STORAGE_AGE_PROPERTY = "storageages";
    public static final long STORAGE_AGE_PROPERTY_DEFAULT = 10L;
    public static final String DISK_SIZE_PROPERTY = "disksize";
    public static final long DISK_SIZE_PROPERTY_DEFAULT = 100000000L;
    public static final String OCCUPANCY_PROPERTY = "occupancy";
    public static final double OCCUPANCY_PROPERTY_DEFAULT = 0.9;

    @Override
    public void init(Properties p) throws WorkloadException {
        this.disksize = Long.parseLong(p.getProperty(DISK_SIZE_PROPERTY, "100000000"));
        this.storageages = Long.parseLong(p.getProperty(STORAGE_AGE_PROPERTY, "10"));
        this.occupancy = Double.parseDouble(p.getProperty(OCCUPANCY_PROPERTY, "0.9"));
        if (p.getProperty("recordcount") != null || p.getProperty("insertcount") != null || p.getProperty("operationcount") != null) {
            System.err.println("Warning: record, insert or operation count was set prior to initting ConstantOccupancyWorkload.  Overriding old values.");
        }
        IntegerGenerator g = CoreWorkload.getFieldLengthGenerator(p);
        double fieldsize = g.mean();
        int fieldcount = Integer.parseInt(p.getProperty("fieldcount", "10"));
        this.object_count = (long)(this.occupancy * ((double)this.disksize / (fieldsize * (double)fieldcount)));
        if (this.object_count == 0L) {
            throw new IllegalStateException("Object count was zero.  Perhaps disksize is too low?");
        }
        p.setProperty("recordcount", this.object_count + "");
        p.setProperty("operationcount", this.storageages * this.object_count + "");
        p.setProperty("insertcount", this.object_count + "");
        super.init(p);
    }
}

