/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.workloads;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.RandomByteIterator;
import com.yahoo.ycsb.StringByteIterator;
import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.Workload;
import com.yahoo.ycsb.WorkloadException;
import com.yahoo.ycsb.generator.AcknowledgedCounterGenerator;
import com.yahoo.ycsb.generator.ConstantIntegerGenerator;
import com.yahoo.ycsb.generator.CounterGenerator;
import com.yahoo.ycsb.generator.DiscreteGenerator;
import com.yahoo.ycsb.generator.ExponentialGenerator;
import com.yahoo.ycsb.generator.Generator;
import com.yahoo.ycsb.generator.HistogramGenerator;
import com.yahoo.ycsb.generator.HotspotIntegerGenerator;
import com.yahoo.ycsb.generator.IntegerGenerator;
import com.yahoo.ycsb.generator.ScrambledZipfianGenerator;
import com.yahoo.ycsb.generator.SkewedLatestGenerator;
import com.yahoo.ycsb.generator.UniformIntegerGenerator;
import com.yahoo.ycsb.generator.ZipfianGenerator;
import com.yahoo.ycsb.measurements.Measurements;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CoreWorkload
extends Workload {
    public static final String TABLENAME_PROPERTY = "table";
    public static final String TABLENAME_PROPERTY_DEFAULT = "usertable";
    public static String table;
    public static final String FIELD_COUNT_PROPERTY = "fieldcount";
    public static final String FIELD_COUNT_PROPERTY_DEFAULT = "10";
    int fieldcount;
    private List<String> fieldnames;
    public static final String FIELD_LENGTH_DISTRIBUTION_PROPERTY = "fieldlengthdistribution";
    public static final String FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT = "constant";
    public static final String FIELD_LENGTH_PROPERTY = "fieldlength";
    public static final String FIELD_LENGTH_PROPERTY_DEFAULT = "100";
    public static final String FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY = "fieldlengthhistogram";
    public static final String FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY_DEFAULT = "hist.txt";
    IntegerGenerator fieldlengthgenerator;
    public static final String READ_ALL_FIELDS_PROPERTY = "readallfields";
    public static final String READ_ALL_FIELDS_PROPERTY_DEFAULT = "true";
    boolean readallfields;
    public static final String WRITE_ALL_FIELDS_PROPERTY = "writeallfields";
    public static final String WRITE_ALL_FIELDS_PROPERTY_DEFAULT = "false";
    boolean writeallfields;
    public static final String DATA_INTEGRITY_PROPERTY = "dataintegrity";
    public static final String DATA_INTEGRITY_PROPERTY_DEFAULT = "false";
    private boolean dataintegrity;
    private final int DATA_INT_MATCH = 0;
    private final int DATA_INT_DEVIATE = 1000;
    private final int DATA_INT_UNEXPECTED_NULL = 2000;
    public static final String READ_PROPORTION_PROPERTY = "readproportion";
    public static final String READ_PROPORTION_PROPERTY_DEFAULT = "0.95";
    public static final String UPDATE_PROPORTION_PROPERTY = "updateproportion";
    public static final String UPDATE_PROPORTION_PROPERTY_DEFAULT = "0.05";
    public static final String INSERT_PROPORTION_PROPERTY = "insertproportion";
    public static final String INSERT_PROPORTION_PROPERTY_DEFAULT = "0.0";
    public static final String SCAN_PROPORTION_PROPERTY = "scanproportion";
    public static final String SCAN_PROPORTION_PROPERTY_DEFAULT = "0.0";
    public static final String READMODIFYWRITE_PROPORTION_PROPERTY = "readmodifywriteproportion";
    public static final String READMODIFYWRITE_PROPORTION_PROPERTY_DEFAULT = "0.0";
    public static final String REQUEST_DISTRIBUTION_PROPERTY = "requestdistribution";
    public static final String REQUEST_DISTRIBUTION_PROPERTY_DEFAULT = "uniform";
    public static final String MAX_SCAN_LENGTH_PROPERTY = "maxscanlength";
    public static final String MAX_SCAN_LENGTH_PROPERTY_DEFAULT = "1000";
    public static final String SCAN_LENGTH_DISTRIBUTION_PROPERTY = "scanlengthdistribution";
    public static final String SCAN_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT = "uniform";
    public static final String INSERT_ORDER_PROPERTY = "insertorder";
    public static final String INSERT_ORDER_PROPERTY_DEFAULT = "hashed";
    public static final String HOTSPOT_DATA_FRACTION = "hotspotdatafraction";
    public static final String HOTSPOT_DATA_FRACTION_DEFAULT = "0.2";
    public static final String HOTSPOT_OPN_FRACTION = "hotspotopnfraction";
    public static final String HOTSPOT_OPN_FRACTION_DEFAULT = "0.8";
    IntegerGenerator keysequence;
    DiscreteGenerator operationchooser;
    IntegerGenerator keychooser;
    Generator fieldchooser;
    AcknowledgedCounterGenerator transactioninsertkeysequence;
    IntegerGenerator scanlength;
    boolean orderedinserts;
    int recordcount;
    private Measurements _measurements = Measurements.getMeasurements();

    protected static IntegerGenerator getFieldLengthGenerator(Properties p) throws WorkloadException {
        IntegerGenerator fieldlengthgenerator;
        String fieldlengthdistribution = p.getProperty(FIELD_LENGTH_DISTRIBUTION_PROPERTY, FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT);
        int fieldlength = Integer.parseInt(p.getProperty(FIELD_LENGTH_PROPERTY, FIELD_LENGTH_PROPERTY_DEFAULT));
        String fieldlengthhistogram = p.getProperty(FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY, FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY_DEFAULT);
        if (fieldlengthdistribution.compareTo(FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT) == 0) {
            fieldlengthgenerator = new ConstantIntegerGenerator(fieldlength);
        } else if (fieldlengthdistribution.compareTo("uniform") == 0) {
            fieldlengthgenerator = new UniformIntegerGenerator(1, fieldlength);
        } else if (fieldlengthdistribution.compareTo("zipfian") == 0) {
            fieldlengthgenerator = new ZipfianGenerator(1L, fieldlength);
        } else if (fieldlengthdistribution.compareTo("histogram") == 0) {
            try {
                fieldlengthgenerator = new HistogramGenerator(fieldlengthhistogram);
            }
            catch (IOException e) {
                throw new WorkloadException("Couldn't read field length histogram file: " + fieldlengthhistogram, e);
            }
        } else {
            throw new WorkloadException("Unknown field length distribution \"" + fieldlengthdistribution + "\"");
        }
        return fieldlengthgenerator;
    }

    @Override
    public void init(Properties p) throws WorkloadException {
        table = p.getProperty(TABLENAME_PROPERTY, TABLENAME_PROPERTY_DEFAULT);
        this.fieldcount = Integer.parseInt(p.getProperty(FIELD_COUNT_PROPERTY, FIELD_COUNT_PROPERTY_DEFAULT));
        this.fieldnames = new ArrayList<String>();
        for (int i = 0; i < this.fieldcount; ++i) {
            this.fieldnames.add("field" + i);
        }
        this.fieldlengthgenerator = CoreWorkload.getFieldLengthGenerator(p);
        double readproportion = Double.parseDouble(p.getProperty(READ_PROPORTION_PROPERTY, READ_PROPORTION_PROPERTY_DEFAULT));
        double updateproportion = Double.parseDouble(p.getProperty(UPDATE_PROPORTION_PROPERTY, UPDATE_PROPORTION_PROPERTY_DEFAULT));
        double insertproportion = Double.parseDouble(p.getProperty(INSERT_PROPORTION_PROPERTY, "0.0"));
        double scanproportion = Double.parseDouble(p.getProperty(SCAN_PROPORTION_PROPERTY, "0.0"));
        double readmodifywriteproportion = Double.parseDouble(p.getProperty(READMODIFYWRITE_PROPORTION_PROPERTY, "0.0"));
        this.recordcount = Integer.parseInt(p.getProperty("recordcount", "0"));
        if (this.recordcount == 0) {
            this.recordcount = Integer.MAX_VALUE;
        }
        String requestdistrib = p.getProperty(REQUEST_DISTRIBUTION_PROPERTY, "uniform");
        int maxscanlength = Integer.parseInt(p.getProperty(MAX_SCAN_LENGTH_PROPERTY, MAX_SCAN_LENGTH_PROPERTY_DEFAULT));
        String scanlengthdistrib = p.getProperty(SCAN_LENGTH_DISTRIBUTION_PROPERTY, "uniform");
        int insertstart = Integer.parseInt(p.getProperty("insertstart", "0"));
        this.readallfields = Boolean.parseBoolean(p.getProperty(READ_ALL_FIELDS_PROPERTY, READ_ALL_FIELDS_PROPERTY_DEFAULT));
        this.writeallfields = Boolean.parseBoolean(p.getProperty(WRITE_ALL_FIELDS_PROPERTY, "false"));
        this.dataintegrity = Boolean.parseBoolean(p.getProperty(DATA_INTEGRITY_PROPERTY, "false"));
        if (this.dataintegrity && !p.getProperty(FIELD_LENGTH_DISTRIBUTION_PROPERTY, FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT).equals(FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT)) {
            System.err.println("Must have constant field size to check data integrity.");
            System.exit(-1);
        }
        if (p.getProperty(INSERT_ORDER_PROPERTY, INSERT_ORDER_PROPERTY_DEFAULT).compareTo(INSERT_ORDER_PROPERTY_DEFAULT) == 0) {
            this.orderedinserts = false;
        } else if (requestdistrib.compareTo("exponential") == 0) {
            double percentile = Double.parseDouble(p.getProperty("exponential.percentile", "95"));
            double frac = Double.parseDouble(p.getProperty("exponential.frac", "0.8571428571"));
            this.keychooser = new ExponentialGenerator(percentile, (double)this.recordcount * frac);
        } else {
            this.orderedinserts = true;
        }
        this.keysequence = new CounterGenerator(insertstart);
        this.operationchooser = new DiscreteGenerator();
        if (readproportion > 0.0) {
            this.operationchooser.addValue(readproportion, "READ");
        }
        if (updateproportion > 0.0) {
            this.operationchooser.addValue(updateproportion, "UPDATE");
        }
        if (insertproportion > 0.0) {
            this.operationchooser.addValue(insertproportion, "INSERT");
        }
        if (scanproportion > 0.0) {
            this.operationchooser.addValue(scanproportion, "SCAN");
        }
        if (readmodifywriteproportion > 0.0) {
            this.operationchooser.addValue(readmodifywriteproportion, "READMODIFYWRITE");
        }
        this.transactioninsertkeysequence = new AcknowledgedCounterGenerator(this.recordcount);
        if (requestdistrib.compareTo("uniform") == 0) {
            this.keychooser = new UniformIntegerGenerator(0, this.recordcount - 1);
        } else if (requestdistrib.compareTo("zipfian") == 0) {
            int opcount = Integer.parseInt(p.getProperty("operationcount"));
            int expectednewkeys = (int)((double)opcount * insertproportion * 2.0);
            this.keychooser = new ScrambledZipfianGenerator(this.recordcount + expectednewkeys);
        } else if (requestdistrib.compareTo("latest") == 0) {
            this.keychooser = new SkewedLatestGenerator(this.transactioninsertkeysequence);
        } else if (requestdistrib.equals("hotspot")) {
            double hotsetfraction = Double.parseDouble(p.getProperty(HOTSPOT_DATA_FRACTION, HOTSPOT_DATA_FRACTION_DEFAULT));
            double hotopnfraction = Double.parseDouble(p.getProperty(HOTSPOT_OPN_FRACTION, HOTSPOT_OPN_FRACTION_DEFAULT));
            this.keychooser = new HotspotIntegerGenerator(0, this.recordcount - 1, hotsetfraction, hotopnfraction);
        } else {
            throw new WorkloadException("Unknown request distribution \"" + requestdistrib + "\"");
        }
        this.fieldchooser = new UniformIntegerGenerator(0, this.fieldcount - 1);
        if (scanlengthdistrib.compareTo("uniform") == 0) {
            this.scanlength = new UniformIntegerGenerator(1, maxscanlength);
        } else if (scanlengthdistrib.compareTo("zipfian") == 0) {
            this.scanlength = new ZipfianGenerator(1L, maxscanlength);
        } else {
            throw new WorkloadException("Distribution \"" + scanlengthdistrib + "\" not allowed for scan length");
        }
    }

    public String buildKeyName(long keynum) {
        if (!this.orderedinserts) {
            keynum = Utils.hash(keynum);
        }
        return "user" + keynum;
    }

    private HashMap<String, ByteIterator> buildSingleValue(String key) {
        HashMap<String, ByteIterator> value = new HashMap<String, ByteIterator>();
        String fieldkey = this.fieldnames.get(Integer.parseInt(this.fieldchooser.nextString()));
        ByteIterator data = this.dataintegrity ? new StringByteIterator(this.buildDeterministicValue(key, fieldkey)) : new RandomByteIterator(this.fieldlengthgenerator.nextInt());
        value.put(fieldkey, data);
        return value;
    }

    private HashMap<String, ByteIterator> buildValues(String key) {
        HashMap<String, ByteIterator> values = new HashMap<String, ByteIterator>();
        for (String fieldkey : this.fieldnames) {
            ByteIterator data = this.dataintegrity ? new StringByteIterator(this.buildDeterministicValue(key, fieldkey)) : new RandomByteIterator(this.fieldlengthgenerator.nextInt());
            values.put(fieldkey, data);
        }
        return values;
    }

    private String buildDeterministicValue(String key, String fieldkey) {
        int size = this.fieldlengthgenerator.nextInt();
        StringBuilder sb = new StringBuilder(size);
        sb.append(key);
        sb.append(':');
        sb.append(fieldkey);
        while (sb.length() < size) {
            sb.append(':');
            sb.append(sb.toString().hashCode());
        }
        sb.setLength(size);
        return sb.toString();
    }

    @Override
    public boolean doInsert(DB db, Object threadstate) {
        HashMap<String, ByteIterator> values;
        int keynum = this.keysequence.nextInt();
        String dbkey = this.buildKeyName(keynum);
        return db.insert(table, dbkey, values = this.buildValues(dbkey)) == 0;
    }

    @Override
    public boolean doTransaction(DB db, Object threadstate) {
        String op = this.operationchooser.nextString();
        if (op.compareTo("READ") == 0) {
            this.doTransactionRead(db);
        } else if (op.compareTo("UPDATE") == 0) {
            this.doTransactionUpdate(db);
        } else if (op.compareTo("INSERT") == 0) {
            this.doTransactionInsert(db);
        } else if (op.compareTo("SCAN") == 0) {
            this.doTransactionScan(db);
        } else {
            this.doTransactionReadModifyWrite(db);
        }
        return true;
    }

    protected void verifyRow(String key, HashMap<String, ByteIterator> cells) {
        int matchType = 0;
        if (!cells.isEmpty()) {
            for (Map.Entry<String, ByteIterator> entry : cells.entrySet()) {
                if (entry.getValue().toString().equals(this.buildDeterministicValue(key, entry.getKey()))) continue;
                matchType = 1000;
                break;
            }
        } else {
            matchType = 2000;
        }
        Measurements.getMeasurements().measure("VERIFY", matchType);
    }

    int nextKeynum() {
        int keynum;
        if (this.keychooser instanceof ExponentialGenerator) {
            while ((keynum = this.transactioninsertkeysequence.lastInt() - this.keychooser.nextInt()) < 0) {
            }
        } else {
            while ((keynum = this.keychooser.nextInt()) > this.transactioninsertkeysequence.lastInt()) {
            }
        }
        return keynum;
    }

    public void doTransactionRead(DB db) {
        int keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = this.fieldnames.get(Integer.parseInt(this.fieldchooser.nextString()));
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        HashMap<String, ByteIterator> cells = new HashMap<String, ByteIterator>();
        db.read(table, keyname, fields, cells);
        if (this.dataintegrity) {
            this.verifyRow(keyname, cells);
        }
    }

    public void doTransactionReadModifyWrite(DB db) {
        int keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = this.fieldnames.get(Integer.parseInt(this.fieldchooser.nextString()));
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        HashMap<String, ByteIterator> values = this.writeallfields ? this.buildValues(keyname) : this.buildSingleValue(keyname);
        HashMap<String, ByteIterator> cells = new HashMap<String, ByteIterator>();
        long ist = this._measurements.getIntendedtartTimeNs();
        long st = System.nanoTime();
        db.read(table, keyname, fields, cells);
        db.update(table, keyname, values);
        long en = System.nanoTime();
        if (this.dataintegrity) {
            this.verifyRow(keyname, cells);
        }
        this._measurements.measure("READ-MODIFY-WRITE", (int)((en - st) / 1000L));
        this._measurements.measureIntended("READ-MODIFY-WRITE", (int)((en - ist) / 1000L));
    }

    public void doTransactionScan(DB db) {
        int keynum = this.nextKeynum();
        String startkeyname = this.buildKeyName(keynum);
        int len = this.scanlength.nextInt();
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = this.fieldnames.get(Integer.parseInt(this.fieldchooser.nextString()));
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        db.scan(table, startkeyname, len, fields, new Vector<HashMap<String, ByteIterator>>());
    }

    public void doTransactionUpdate(DB db) {
        int keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashMap<String, ByteIterator> values = this.writeallfields ? this.buildValues(keyname) : this.buildSingleValue(keyname);
        db.update(table, keyname, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTransactionInsert(DB db) {
        int keynum = this.transactioninsertkeysequence.nextInt();
        try {
            String dbkey = this.buildKeyName(keynum);
            HashMap<String, ByteIterator> values = this.buildValues(dbkey);
            db.insert(table, dbkey, values);
        }
        finally {
            this.transactioninsertkeysequence.acknowledge(keynum);
        }
    }
}

