/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.JsonSerializationVisitor;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.SymbolElement;
import com.allanbank.mongodb.bson.impl.ImmutableDocument;
import com.allanbank.mongodb.bson.json.Json;
import com.allanbank.mongodb.error.JsonParseException;
import java.io.Serializable;
import java.io.StringWriter;

public class Durability
implements Serializable {
    public static final Durability ACK = new Durability(true, false, false, 1, null, 0);
    public static final String MAJORITY_MODE = "majority";
    public static final Durability NONE = new Durability(false, false, false, 0, null, 0);
    private static final long serialVersionUID = -6474266523435876385L;
    private Document myAsDocument;
    private final boolean myWaitForFsync;
    private final boolean myWaitForJournal;
    private final int myWaitForReplicas;
    private final String myWaitForReplicasByMode;
    private final boolean myWaitForReply;
    private final int myWaitTimeoutMillis;

    public static Durability fsyncDurable(int n) {
        return new Durability(true, false, 0, n);
    }

    public static Durability journalDurable(int n) {
        return new Durability(false, true, 0, n);
    }

    public static Durability replicaDurable(boolean bl, int n, int n2) {
        return new Durability(false, bl, n, n2);
    }

    public static Durability replicaDurable(boolean bl, String string, int n) {
        return new Durability(false, bl, string, n);
    }

    public static Durability replicaDurable(int n) {
        return new Durability(false, false, 2, n);
    }

    public static Durability replicaDurable(int n, int n2) {
        return new Durability(false, false, n, n2);
    }

    public static Durability replicaDurable(String string, int n) {
        return new Durability(false, false, string, n);
    }

    public static Durability valueOf(String string) {
        Durability durability = null;
        if ("ACK".equalsIgnoreCase(string) || "SAFE".equalsIgnoreCase(string)) {
            durability = ACK;
        } else if ("NONE".equalsIgnoreCase(string)) {
            durability = NONE;
        } else {
            try {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                int n = 0;
                String string2 = null;
                int n2 = 0;
                Document document = Json.parse(string);
                for (Element element : document) {
                    if ("getlasterror".equalsIgnoreCase(element.getName())) continue;
                    if ("w".equalsIgnoreCase(element.getName())) {
                        bl = true;
                        if (element instanceof NumericElement) {
                            n = ((NumericElement)element).getIntValue();
                            continue;
                        }
                        if (element instanceof StringElement) {
                            string2 = ((StringElement)element).getValue();
                            continue;
                        }
                        if (element instanceof SymbolElement) {
                            string2 = ((SymbolElement)element).getSymbol();
                            continue;
                        }
                        return null;
                    }
                    if ("wtimeout".equalsIgnoreCase(element.getName())) {
                        if (element instanceof NumericElement) {
                            n2 = ((NumericElement)element).getIntValue();
                            continue;
                        }
                        return null;
                    }
                    if ("fsync".equalsIgnoreCase(element.getName())) {
                        bl = true;
                        bl2 = true;
                        continue;
                    }
                    if ("j".equalsIgnoreCase(element.getName())) {
                        bl = true;
                        bl3 = true;
                        continue;
                    }
                    return null;
                }
                durability = new Durability(bl, bl2, bl3, n, string2, n2);
            }
            catch (JsonParseException jsonParseException) {
                jsonParseException.getCause();
            }
        }
        return durability;
    }

    protected Durability(boolean bl, boolean bl2, int n, int n2) {
        this(true, bl, bl2, n, null, n2);
    }

    protected Durability(boolean bl, boolean bl2, String string, int n) {
        this(true, bl, bl2, 0, string, n);
    }

    private Durability(boolean bl, boolean bl2, boolean bl3, int n, String string, int n2) {
        this.myWaitForReply = bl;
        this.myWaitForFsync = bl2;
        this.myWaitForJournal = bl3;
        this.myWaitForReplicas = n;
        this.myWaitTimeoutMillis = n2;
        this.myWaitForReplicasByMode = string;
    }

    public Document asDocument() {
        if (this.myAsDocument == null) {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            documentBuilder.addInteger("getlasterror", 1);
            if (this.isWaitForJournal()) {
                documentBuilder.addBoolean("j", true);
            }
            if (this.isWaitForFsync()) {
                documentBuilder.addBoolean("fsync", true);
            }
            if (this.getWaitTimeoutMillis() > 0) {
                documentBuilder.addInteger("wtimeout", this.getWaitTimeoutMillis());
            }
            if (this.getWaitForReplicas() >= 1) {
                documentBuilder.addInteger("w", this.getWaitForReplicas());
            } else if (this.getWaitForReplicasByMode() != null) {
                documentBuilder.addString("w", this.getWaitForReplicasByMode());
            }
            this.myAsDocument = new ImmutableDocument(documentBuilder);
        }
        return this.myAsDocument;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Durability durability = (Durability)object;
            bl = this.myWaitForReply == durability.myWaitForReply && this.myWaitForFsync == durability.myWaitForFsync && this.myWaitForJournal == durability.myWaitForJournal && this.myWaitForReplicas == durability.myWaitForReplicas && this.myWaitTimeoutMillis == durability.myWaitTimeoutMillis && this.nullSafeEquals(this.myWaitForReplicasByMode, durability.myWaitForReplicasByMode);
        }
        return bl;
    }

    public int getWaitForReplicas() {
        return this.myWaitForReplicas;
    }

    public String getWaitForReplicasByMode() {
        return this.myWaitForReplicasByMode;
    }

    public int getWaitTimeoutMillis() {
        return this.myWaitTimeoutMillis;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.myWaitForReply ? 1 : 3);
        n = 31 * n + (this.myWaitForFsync ? 1 : 3);
        n = 31 * n + (this.myWaitForJournal ? 1 : 3);
        n = 31 * n + (this.myWaitForReplicasByMode != null ? this.myWaitForReplicasByMode.hashCode() : 3);
        n = 31 * n + this.myWaitForReplicas;
        n = 31 * n + this.myWaitTimeoutMillis;
        return n;
    }

    public boolean isWaitForFsync() {
        return this.myWaitForFsync;
    }

    public boolean isWaitForJournal() {
        return this.myWaitForJournal;
    }

    public boolean isWaitForReply() {
        return this.myWaitForReply;
    }

    public String toString() {
        String string;
        if (NONE.equals(this)) {
            string = "NONE";
        } else if (ACK.equals(this)) {
            string = "ACK";
        } else {
            StringWriter stringWriter = new StringWriter();
            JsonSerializationVisitor jsonSerializationVisitor = new JsonSerializationVisitor(stringWriter, true);
            this.asDocument().accept(jsonSerializationVisitor);
            string = stringWriter.toString();
        }
        return string;
    }

    protected boolean nullSafeEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private Object readResolve() {
        if (this.equals(ACK)) {
            return ACK;
        }
        if (this.equals(NONE)) {
            return NONE;
        }
        return this;
    }
}

