/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoDbUri;
import java.beans.PropertyEditorSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DurabilityEditor
extends PropertyEditorSupport {
    public static final int DEFAULT_WAIT_TIME_MS = 30000;
    public static final Set<String> MONGODB_URI_FIELDS;

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if ("NONE".equalsIgnoreCase(string)) {
            this.setValue(Durability.NONE);
        } else if ("ACK".equalsIgnoreCase(string)) {
            this.setValue(Durability.ACK);
        } else if ("FSYNC".equalsIgnoreCase(string)) {
            this.setValue(Durability.fsyncDurable(30000));
        } else if ("JOURNAL".equalsIgnoreCase(string)) {
            this.setValue(Durability.journalDurable(30000));
        } else if ("MAJORITY".equalsIgnoreCase(string)) {
            this.setValue(Durability.replicaDurable("majority", 30000));
        } else if (MongoDbUri.isUri(string)) {
            MongoDbUri mongoDbUri = new MongoDbUri(string);
            Durability durability = this.fromUriParameters(mongoDbUri.getParsedOptions());
            if (durability != null) {
                this.setValue(durability);
            }
        } else {
            Durability durability = Durability.valueOf(string);
            if (durability != null) {
                this.setValue(durability);
            } else {
                throw new IllegalArgumentException("Could not determine the durability for '" + string + "'.");
            }
        }
    }

    private Durability fromUriParameters(Map<String, String> map) {
        boolean bl = false;
        int n = 1;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string2 = entry.getKey();
            String string3 = entry.getValue();
            if ("safe".equalsIgnoreCase(string2)) {
                bl = Boolean.parseBoolean(string3);
                continue;
            }
            if ("w".equalsIgnoreCase(string2)) {
                bl = true;
                try {
                    n = Integer.parseInt(string3);
                    string = null;
                }
                catch (NumberFormatException numberFormatException) {
                    n = 2;
                    string = string3;
                }
                continue;
            }
            if ("wtimeout".equalsIgnoreCase(string2) || "wtimeoutms".equalsIgnoreCase(string2)) {
                bl = true;
                n2 = Integer.parseInt(string3);
                if (n > 1) continue;
                n = 2;
                continue;
            }
            if ("fsync".equalsIgnoreCase(string2)) {
                bl2 = Boolean.parseBoolean(string3);
                if (!bl2) continue;
                bl3 = false;
                bl = true;
                continue;
            }
            if (!"journal".equalsIgnoreCase(string2) || !(bl3 = Boolean.parseBoolean(string3))) continue;
            bl2 = false;
            bl = true;
        }
        Object object = null;
        if (bl) {
            if (bl2) {
                object = Durability.fsyncDurable(n2);
            } else if (bl3) {
                object = Durability.journalDurable(n2);
            } else if (n == 1) {
                object = Durability.ACK;
            } else if (n > 1) {
                object = string != null ? Durability.replicaDurable(string, n2) : Durability.replicaDurable(n, n2);
            } else if (n <= 0) {
                object = Durability.NONE;
            }
        }
        return object;
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("safe");
        hashSet.add("w");
        hashSet.add("wtimeout");
        hashSet.add("wtimeoutms");
        hashSet.add("fsync");
        hashSet.add("journal");
        MONGODB_URI_FIELDS = Collections.unmodifiableSet(hashSet);
    }
}

