/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.ConnectionModel;
import com.allanbank.mongodb.Credential;
import com.allanbank.mongodb.CredentialEditor;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.DurabilityEditor;
import com.allanbank.mongodb.LockType;
import com.allanbank.mongodb.MongoDbUri;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.ReadPreferenceEditor;
import com.allanbank.mongodb.error.MongoDbAuthenticationException;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.ServerNameUtils;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class MongoClientConfiguration
implements Cloneable,
Serializable {
    public static final String ADMIN_DB_NAME = "admin";
    public static final String DEFAULT_DB_NAME = "local";
    public static final Charset UTF8 = Charset.forName("UTF-8");
    protected static final int DEFAULT_MAX_STRING_CACHE_ENTRIES = 1024;
    protected static final int DEFAULT_MAX_STRING_CACHE_LENGTH = 25;
    private static final Log LOG = LogFactory.getLog(MongoClientConfiguration.class);
    private static final long serialVersionUID = 2964127883934086500L;
    private boolean myAutoDiscoverServers = true;
    private ConnectionModel myConnectionModel = ConnectionModel.RECEIVER_THREAD;
    private int myConnectTimeout = 0;
    private ConcurrentHashMap<String, Credential> myCredentials;
    private String myDefaultDatabase = "local";
    private Durability myDefaultDurability = Durability.ACK;
    private ReadPreference myDefaultReadPreference = ReadPreference.PRIMARY;
    private transient Executor myExecutor = null;
    private Credential myLegacyCredential;
    private LockType myLockType = LockType.MUTEX;
    private int myMaxCachedStringEntries = 1024;
    private int myMaxCachedStringLength = 25;
    private int myMaxConnectionCount = 3;
    private int myMaxIdleTickCount = Integer.MAX_VALUE;
    private int myMaxPendingOperationsPerConnection = 1024;
    private long myMaxSecondaryLag = TimeUnit.MINUTES.toMillis(5L);
    private int myMinConnectionCount = 0;
    private PropertyChangeSupport myPropSupport;
    private int myReadTimeout = 0;
    private int myReconnectTimeout = 0;
    private List<InetSocketAddress> myServers = new ArrayList<InetSocketAddress>();
    private transient SocketFactory mySocketFactory = null;
    private transient ThreadFactory myThreadFactory = Executors.defaultThreadFactory();
    private boolean myUsingSoKeepalive = true;

    public MongoClientConfiguration() {
        this.myCredentials = new ConcurrentHashMap();
        this.myPropSupport = new PropertyChangeSupport(this);
    }

    public MongoClientConfiguration(InetSocketAddress ... inetSocketAddressArray) {
        this();
        for (InetSocketAddress inetSocketAddress : inetSocketAddressArray) {
            this.addServer(inetSocketAddress);
        }
    }

    public MongoClientConfiguration(MongoClientConfiguration mongoClientConfiguration) {
        this();
        this.myAutoDiscoverServers = mongoClientConfiguration.isAutoDiscoverServers();
        this.myConnectionModel = mongoClientConfiguration.getConnectionModel();
        this.myConnectTimeout = mongoClientConfiguration.getConnectTimeout();
        this.myDefaultDatabase = mongoClientConfiguration.getDefaultDatabase();
        this.myDefaultDurability = mongoClientConfiguration.getDefaultDurability();
        this.myDefaultReadPreference = mongoClientConfiguration.getDefaultReadPreference();
        this.myExecutor = mongoClientConfiguration.getExecutor();
        this.myLockType = mongoClientConfiguration.getLockType();
        this.myMaxCachedStringEntries = mongoClientConfiguration.getMaxCachedStringEntries();
        this.myMaxCachedStringLength = mongoClientConfiguration.getMaxCachedStringLength();
        this.myMaxConnectionCount = mongoClientConfiguration.getMaxConnectionCount();
        this.myMaxIdleTickCount = mongoClientConfiguration.getMaxIdleTickCount();
        this.myMaxPendingOperationsPerConnection = mongoClientConfiguration.getMaxPendingOperationsPerConnection();
        this.myMaxSecondaryLag = mongoClientConfiguration.getMaxSecondaryLag();
        this.myMinConnectionCount = mongoClientConfiguration.getMinConnectionCount();
        this.myReadTimeout = mongoClientConfiguration.getReadTimeout();
        this.myReconnectTimeout = mongoClientConfiguration.getReconnectTimeout();
        this.mySocketFactory = mongoClientConfiguration.getSocketFactory();
        this.myThreadFactory = mongoClientConfiguration.getThreadFactory();
        this.myUsingSoKeepalive = mongoClientConfiguration.isUsingSoKeepalive();
        for (Credential serializable : mongoClientConfiguration.getCredentials()) {
            this.addCredential(serializable);
        }
        for (InetSocketAddress inetSocketAddress : mongoClientConfiguration.getServerAddresses()) {
            this.addServer(inetSocketAddress);
        }
    }

    public MongoClientConfiguration(MongoDbUri mongoDbUri) throws IllegalArgumentException {
        this(mongoDbUri, Durability.ACK);
    }

    public MongoClientConfiguration(String string) throws IllegalArgumentException {
        this(new MongoDbUri(string));
    }

    protected MongoClientConfiguration(MongoDbUri mongoDbUri, Durability durability) throws IllegalArgumentException {
        this();
        PropertyDescriptor[] propertyDescriptorArray;
        Object throwable;
        Object object;
        this.myDefaultDurability = durability;
        for (String object32 : mongoDbUri.getHosts()) {
            this.addServer(object32);
        }
        if (this.myServers.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least 1 host to connect to.");
        }
        if (!mongoDbUri.getDatabase().isEmpty()) {
            this.setDefaultDatabase(mongoDbUri.getDatabase());
        }
        Map<String, String> map = mongoDbUri.getParsedOptions();
        HashMap hashMap = new HashMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            throwable = (String)object.getKey();
            if ("sockettimeoutms".equals(object.getKey())) {
                hashMap.put("readtimeout", object.getValue());
                iterator.remove();
                continue;
            }
            if ("usesokeepalive".equals(throwable)) {
                hashMap.put("usingsokeepalive", object.getValue());
                iterator.remove();
                continue;
            }
            if ("minpoolsize".equals(throwable)) {
                hashMap.put("minconnectioncount", object.getValue());
                iterator.remove();
                continue;
            }
            if ("maxpoolsize".equals(throwable)) {
                hashMap.put("maxconnectioncount", object.getValue());
                iterator.remove();
                continue;
            }
            if (!((String)throwable).endsWith("ms")) continue;
            propertyDescriptorArray = ((String)throwable).substring(0, ((String)throwable).length() - "ms".length());
            hashMap.put(propertyDescriptorArray, object.getValue());
            iterator.remove();
        }
        map.putAll(hashMap);
        map.keySet().removeAll(CredentialEditor.MONGODB_URI_FIELDS);
        map.put("credentials", mongoDbUri.toString());
        if (map.keySet().removeAll(DurabilityEditor.MONGODB_URI_FIELDS)) {
            map.put("defaultdurability", mongoDbUri.toString());
        }
        if (map.keySet().removeAll(ReadPreferenceEditor.MONGODB_URI_FIELDS)) {
            map.put("defaultreadpreference", mongoDbUri.toString());
        }
        object = (String)map.remove("ssl");
        if (mongoDbUri.isUseSsl() || object != null) {
            if (mongoDbUri.isUseSsl() || Boolean.parseBoolean((String)object)) {
                try {
                    this.setSocketFactory((SocketFactory)Class.forName("com.allanbank.mongodb.extensions.tls.TlsSocketFactory").newInstance());
                }
                catch (Throwable introspectionException) {
                    this.setSocketFactory(SSLSocketFactory.getDefault());
                    LOG.warn("Using the JVM default SSL Socket Factory. This may allow man-in-the-middle attacks. See http://www.allanbank.com/mongodb-async-driver/userguide/tls.html");
                }
            } else {
                this.setSocketFactory(null);
            }
        }
        try {
            throwable = Introspector.getBeanInfo(MongoClientConfiguration.class);
            propertyDescriptorArray = throwable.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> hashMap2 = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                hashMap2.put(propertyDescriptor.getName().toLowerCase(Locale.US), propertyDescriptor);
            }
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)hashMap2.get(string);
                if (propertyDescriptor != null) {
                    try {
                        this.updateFieldValue(propertyDescriptor, string, string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("The '" + string + "' parameter must have a numeric value not '" + string2 + "'.", numberFormatException);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("The '" + string + "' parameter's editor could not be set '" + string2 + "'.", exception);
                    }
                }
                if ("uuidrepresentation".equals(string)) {
                    LOG.info("Changing the UUID representation is not supported.");
                    continue;
                }
                if ("replicaset".equals(string)) {
                    LOG.info("Not validating the replica set name is '{}'.", string2);
                    continue;
                }
                LOG.info("Unknown property '{}' and value '{}'.", string, string2);
            }
        }
        catch (IntrospectionException introspectionException) {
            throw new IllegalArgumentException("Could not introspect on the MongoClientConfiguration.");
        }
    }

    public void addCredential(Credential credential) throws IllegalArgumentException {
        ArrayList<Credential> arrayList = new ArrayList<Credential>(this.myCredentials.values());
        try {
            credential.loadAuthenticator();
            Credential credential2 = this.myCredentials.putIfAbsent(credential.getDatabase(), credential);
            if (credential2 != null) {
                throw new IllegalArgumentException("There can only be one set of credentials for each database.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not load the credentials authenticator.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Could not load the credentials authenticator.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not load the credentials authenticator.", illegalAccessException);
        }
        this.myPropSupport.firePropertyChange("credentials", arrayList, new ArrayList<Credential>(this.myCredentials.values()));
    }

    public void addCredential(Credential.Builder builder) throws IllegalArgumentException {
        this.addCredential(builder.build());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPropSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.myPropSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void addServer(InetSocketAddress inetSocketAddress) {
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(this.myServers);
        this.myServers.add(inetSocketAddress);
        this.myPropSupport.firePropertyChange("servers", arrayList, Collections.unmodifiableList(this.myServers));
    }

    public void addServer(String string) {
        this.addServer(ServerNameUtils.parse(string));
    }

    @Deprecated
    public void authenticate(String string, String string2) throws MongoDbAuthenticationException {
        if (this.myLegacyCredential != null) {
            this.myCredentials.remove(this.myLegacyCredential.getDatabase());
        }
        this.myLegacyCredential = Credential.builder().userName(string).password(string2.toCharArray()).database(this.getDefaultDatabase()).mongodbCR().build();
        this.addCredential(this.myLegacyCredential);
    }

    @Deprecated
    public void authenticateAsAdmin(String string, String string2) throws MongoDbAuthenticationException {
        this.addCredential(Credential.builder().userName(string).password(string2.toCharArray()).database(ADMIN_DB_NAME).mongodbCR().build());
    }

    public MongoClientConfiguration clone() {
        MongoClientConfiguration mongoClientConfiguration = null;
        try {
            mongoClientConfiguration = (MongoClientConfiguration)super.clone();
            mongoClientConfiguration.myCredentials = new ConcurrentHashMap();
            for (Credential serializable : this.getCredentials()) {
                mongoClientConfiguration.addCredential(serializable);
            }
            mongoClientConfiguration.myServers = new ArrayList<InetSocketAddress>();
            for (InetSocketAddress inetSocketAddress : this.getServerAddresses()) {
                mongoClientConfiguration.addServer(inetSocketAddress);
            }
            mongoClientConfiguration.myPropSupport = new PropertyChangeSupport(mongoClientConfiguration);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mongoClientConfiguration = new MongoClientConfiguration(this);
        }
        return mongoClientConfiguration;
    }

    public ConnectionModel getConnectionModel() {
        return this.myConnectionModel;
    }

    public int getConnectTimeout() {
        return this.myConnectTimeout;
    }

    public Collection<Credential> getCredentials() {
        return Collections.unmodifiableCollection(this.myCredentials.values());
    }

    @Deprecated
    public String getDefaultDatabase() {
        return this.myDefaultDatabase;
    }

    public Durability getDefaultDurability() {
        return this.myDefaultDurability;
    }

    public ReadPreference getDefaultReadPreference() {
        return this.myDefaultReadPreference;
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    public LockType getLockType() {
        return this.myLockType;
    }

    public int getMaxCachedStringEntries() {
        return this.myMaxCachedStringEntries;
    }

    public int getMaxCachedStringLength() {
        return this.myMaxCachedStringLength;
    }

    public int getMaxConnectionCount() {
        return this.myMaxConnectionCount;
    }

    public int getMaxIdleTickCount() {
        return this.myMaxIdleTickCount;
    }

    public int getMaxPendingOperationsPerConnection() {
        return this.myMaxPendingOperationsPerConnection;
    }

    public long getMaxSecondaryLag() {
        return this.myMaxSecondaryLag;
    }

    public int getMinConnectionCount() {
        return this.myMinConnectionCount;
    }

    @Deprecated
    public String getPasswordHash() {
        if (!this.myCredentials.isEmpty()) {
            Credential credential = this.myCredentials.entrySet().iterator().next().getValue();
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                byte[] byArray = messageDigest.digest((credential.getUserName() + ":mongo:" + new String(credential.getPassword())).getBytes(UTF8));
                return IOUtils.toHex(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MongoDbAuthenticationException(noSuchAlgorithmException);
            }
        }
        return null;
    }

    public int getReadTimeout() {
        return this.myReadTimeout;
    }

    public int getReconnectTimeout() {
        return this.myReconnectTimeout;
    }

    public List<InetSocketAddress> getServerAddresses() {
        return Collections.unmodifiableList(this.myServers);
    }

    public List<String> getServers() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myServers.size());
        for (InetSocketAddress inetSocketAddress : this.myServers) {
            arrayList.add(ServerNameUtils.normalize(inetSocketAddress));
        }
        return arrayList;
    }

    public SocketFactory getSocketFactory() {
        if (this.mySocketFactory == null) {
            this.mySocketFactory = SocketFactory.getDefault();
        }
        return this.mySocketFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.myThreadFactory;
    }

    @Deprecated
    public String getUserName() {
        if (!this.myCredentials.isEmpty()) {
            Credential credential = this.myCredentials.entrySet().iterator().next().getValue();
            return credential.getUserName();
        }
        return null;
    }

    @Deprecated
    public boolean isAdminUser() {
        return this.myCredentials.containsKey(ADMIN_DB_NAME);
    }

    public boolean isAuthenticating() {
        return !this.myCredentials.isEmpty();
    }

    public boolean isAutoDiscoverServers() {
        return this.myAutoDiscoverServers;
    }

    public boolean isUsingSoKeepalive() {
        return this.myUsingSoKeepalive;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myPropSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.myPropSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void setAutoDiscoverServers(boolean bl) {
        boolean bl2 = this.myAutoDiscoverServers;
        this.myAutoDiscoverServers = bl;
        this.myPropSupport.firePropertyChange("autoDiscoverServers", bl2, this.myAutoDiscoverServers);
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        ConnectionModel connectionModel2 = this.myConnectionModel;
        this.myConnectionModel = connectionModel;
        this.myPropSupport.firePropertyChange("connectionModel", (Object)connectionModel2, (Object)this.myConnectionModel);
    }

    public void setConnectTimeout(int n) {
        int n2 = this.myConnectTimeout;
        this.myConnectTimeout = n;
        this.myPropSupport.firePropertyChange("connectTimeout", n2, this.myConnectTimeout);
    }

    public void setCredentials(Collection<Credential> collection) {
        ArrayList<Credential> arrayList = new ArrayList<Credential>(this.myCredentials.values());
        this.myCredentials.clear();
        for (Credential credential : collection) {
            this.addCredential(credential);
        }
        this.myPropSupport.firePropertyChange("credentials", arrayList, new ArrayList<Credential>(this.myCredentials.values()));
    }

    @Deprecated
    public void setDefaultDatabase(String string) {
        String string2 = this.myDefaultDatabase;
        this.myDefaultDatabase = string;
        if (this.myLegacyCredential != null) {
            ArrayList<Credential> arrayList = new ArrayList<Credential>(this.myCredentials.values());
            this.myCredentials.remove(this.myLegacyCredential.getDatabase());
            this.myPropSupport.firePropertyChange("credentials", arrayList, new ArrayList<Credential>(this.myCredentials.values()));
            this.myLegacyCredential = Credential.builder().userName(this.myLegacyCredential.getUserName()).password(this.myLegacyCredential.getPassword()).database(string).mongodbCR().build();
            this.addCredential(this.myLegacyCredential);
        }
        this.myPropSupport.firePropertyChange("defaultDatabase", string2, this.myDefaultDatabase);
    }

    public void setDefaultDurability(Durability durability) {
        Durability durability2 = this.myDefaultDurability;
        this.myDefaultDurability = durability;
        this.myPropSupport.firePropertyChange("defaultDurability", durability2, this.myDefaultDurability);
    }

    public void setDefaultReadPreference(ReadPreference readPreference) {
        ReadPreference readPreference2 = this.myDefaultReadPreference;
        this.myDefaultReadPreference = readPreference == null ? ReadPreference.PRIMARY : readPreference;
        this.myPropSupport.firePropertyChange("defaultReadPreference", readPreference2, this.myDefaultReadPreference);
    }

    public void setExecutor(Executor executor) {
        Executor executor2 = this.myExecutor;
        this.myExecutor = executor;
        this.myPropSupport.firePropertyChange("executor", executor2, this.myExecutor);
    }

    public void setLockType(LockType lockType) {
        LockType lockType2 = this.myLockType;
        this.myLockType = lockType;
        this.myPropSupport.firePropertyChange("lockType", (Object)lockType2, (Object)this.myLockType);
    }

    public void setMaxCachedStringEntries(int n) {
        int n2 = this.myMaxCachedStringEntries;
        this.myMaxCachedStringEntries = n;
        this.myPropSupport.firePropertyChange("maxCachedStringEntries", n2, this.myMaxCachedStringEntries);
    }

    public void setMaxCachedStringLength(int n) {
        int n2 = this.myMaxCachedStringLength;
        this.myMaxCachedStringLength = n;
        this.myPropSupport.firePropertyChange("maxCachedStringLength", n2, this.myMaxCachedStringLength);
    }

    public void setMaxConnectionCount(int n) {
        int n2 = this.myMaxConnectionCount;
        this.myMaxConnectionCount = n;
        this.myPropSupport.firePropertyChange("maxConnectionCount", n2, this.myMaxConnectionCount);
    }

    public void setMaxIdleTickCount(int n) {
        int n2 = this.myMaxIdleTickCount;
        this.myMaxIdleTickCount = n;
        this.myPropSupport.firePropertyChange("maxIdleTickCount", n2, this.myMaxIdleTickCount);
    }

    public void setMaxPendingOperationsPerConnection(int n) {
        int n2 = this.myMaxPendingOperationsPerConnection;
        this.myMaxPendingOperationsPerConnection = n;
        this.myPropSupport.firePropertyChange("maxPendingOperationsPerConnection", n2, this.myMaxPendingOperationsPerConnection);
    }

    public void setMaxSecondaryLag(long l) {
        long l2 = this.myMaxSecondaryLag;
        this.myMaxSecondaryLag = l;
        this.myPropSupport.firePropertyChange("maxSecondaryLag", l2, this.myMaxSecondaryLag);
    }

    public void setMinConnectionCount(int n) {
        int n2 = this.myMinConnectionCount;
        this.myMinConnectionCount = n;
        this.myPropSupport.firePropertyChange("minConnectionCount", n2, this.myMinConnectionCount);
    }

    public void setReadTimeout(int n) {
        int n2 = this.myReadTimeout;
        this.myReadTimeout = n;
        this.myPropSupport.firePropertyChange("readTimeout", n2, this.myReadTimeout);
    }

    public void setReconnectTimeout(int n) {
        int n2 = this.myReconnectTimeout;
        this.myReconnectTimeout = n;
        this.myPropSupport.firePropertyChange("reconnectTimeout", n2, this.myReconnectTimeout);
    }

    public void setServers(List<InetSocketAddress> list) {
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(this.myServers);
        this.myServers.clear();
        if (list != null) {
            for (InetSocketAddress inetSocketAddress : list) {
                this.addServer(inetSocketAddress);
            }
        }
        this.myPropSupport.firePropertyChange("servers", arrayList, Collections.unmodifiableList(this.myServers));
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        SocketFactory socketFactory2 = this.mySocketFactory;
        this.mySocketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.myPropSupport.firePropertyChange("socketFactory", socketFactory2, this.mySocketFactory);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        ThreadFactory threadFactory2 = this.myThreadFactory;
        this.myThreadFactory = threadFactory;
        this.myPropSupport.firePropertyChange("threadFactory", threadFactory2, this.myThreadFactory);
    }

    public void setUsingSoKeepalive(boolean bl) {
        boolean bl2 = this.myUsingSoKeepalive;
        this.myUsingSoKeepalive = bl;
        this.myPropSupport.firePropertyChange("usingSoKeepalive", bl2, this.myUsingSoKeepalive);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.myExecutor = null;
        this.mySocketFactory = null;
        this.myThreadFactory = null;
    }

    private void updateFieldValue(PropertyDescriptor propertyDescriptor, String string, String string2) throws IllegalArgumentException {
        block6: {
            try {
                Class<?> clazz = propertyDescriptor.getPropertyType();
                Method method = propertyDescriptor.getWriteMethod();
                Class<?> clazz2 = propertyDescriptor.getPropertyEditorClass();
                PropertyEditor propertyEditor = clazz2 != null ? (PropertyEditor)clazz2.newInstance() : PropertyEditorManager.findEditor(clazz);
                if (propertyEditor != null) {
                    Method method2 = propertyDescriptor.getReadMethod();
                    propertyEditor.setValue(method2.invoke((Object)this, new Object[0]));
                    propertyEditor.setAsText(string2);
                    method.invoke((Object)this, propertyEditor.getValue());
                    break block6;
                }
                if (clazz.isEnum()) {
                    Class<?> clazz3 = clazz;
                    method.invoke((Object)this, Enum.valueOf(clazz3, string2));
                    break block6;
                }
                throw new IllegalArgumentException("The '" + string + "' parameter could not be set " + "to the value '" + string2 + "'. No editor available.");
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalArgumentException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException(invocationTargetException);
            }
        }
    }
}

