/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.AsyncMongoCollection;
import com.allanbank.mongodb.BatchedAsyncMongoCollection;
import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.IntegerElement;
import com.allanbank.mongodb.builder.Aggregate;
import com.allanbank.mongodb.builder.BatchedWrite;
import com.allanbank.mongodb.builder.Count;
import com.allanbank.mongodb.builder.Distinct;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.FindAndModify;
import com.allanbank.mongodb.builder.GroupBy;
import com.allanbank.mongodb.builder.MapReduce;
import com.allanbank.mongodb.builder.ParallelScan;
import com.allanbank.mongodb.builder.Text;
import com.allanbank.mongodb.builder.TextResult;
import java.util.Collection;

public interface MongoCollection
extends AsyncMongoCollection {
    public static final Document ALL = AsyncMongoCollection.ALL;
    public static final Document NONE = AsyncMongoCollection.NONE;

    public MongoIterator<Document> aggregate(Aggregate var1) throws MongoDbException;

    public MongoIterator<Document> aggregate(Aggregate.Builder var1) throws MongoDbException;

    public long count() throws MongoDbException;

    public long count(Count var1) throws MongoDbException;

    public long count(Count.Builder var1) throws MongoDbException;

    public long count(DocumentAssignable var1) throws MongoDbException;

    public long count(DocumentAssignable var1, ReadPreference var2) throws MongoDbException;

    public long count(ReadPreference var1) throws MongoDbException;

    public void createIndex(boolean var1, Element ... var2) throws MongoDbException;

    public void createIndex(DocumentAssignable var1, Element ... var2) throws MongoDbException;

    public void createIndex(Element ... var1) throws MongoDbException;

    public void createIndex(String var1, boolean var2, Element ... var3) throws MongoDbException;

    public void createIndex(String var1, DocumentAssignable var2, Element ... var3) throws MongoDbException;

    public long delete(DocumentAssignable var1) throws MongoDbException;

    public long delete(DocumentAssignable var1, boolean var2) throws MongoDbException;

    public long delete(DocumentAssignable var1, boolean var2, Durability var3) throws MongoDbException;

    public long delete(DocumentAssignable var1, Durability var2) throws MongoDbException;

    public MongoIterator<Element> distinct(Distinct var1) throws MongoDbException;

    public MongoIterator<Element> distinct(Distinct.Builder var1) throws MongoDbException;

    public boolean drop() throws MongoDbException;

    public boolean dropIndex(IntegerElement ... var1) throws MongoDbException;

    public boolean dropIndex(String var1) throws MongoDbException;

    public boolean exists() throws MongoDbException;

    public Document explain(Aggregate var1) throws MongoDbException;

    public Document explain(Aggregate.Builder var1) throws MongoDbException;

    public Document explain(DocumentAssignable var1) throws MongoDbException;

    public Document explain(Find var1) throws MongoDbException;

    public Document explain(Find.Builder var1) throws MongoDbException;

    public MongoIterator<Document> find(DocumentAssignable var1) throws MongoDbException;

    public MongoIterator<Document> find(Find var1) throws MongoDbException;

    public MongoIterator<Document> find(Find.Builder var1) throws MongoDbException;

    public Document findAndModify(FindAndModify var1) throws MongoDbException;

    public Document findAndModify(FindAndModify.Builder var1) throws MongoDbException;

    public Document findOne(DocumentAssignable var1) throws MongoDbException;

    public Document findOne(Find var1) throws MongoDbException;

    public Document findOne(Find.Builder var1) throws MongoDbException;

    public String getDatabaseName();

    public Durability getDurability();

    public String getName();

    public ReadPreference getReadPreference();

    public MongoIterator<Element> groupBy(GroupBy var1) throws MongoDbException;

    public MongoIterator<Element> groupBy(GroupBy.Builder var1) throws MongoDbException;

    public int insert(boolean var1, DocumentAssignable ... var2) throws MongoDbException;

    public int insert(boolean var1, Durability var2, DocumentAssignable ... var3) throws MongoDbException;

    public int insert(DocumentAssignable ... var1) throws MongoDbException;

    public int insert(Durability var1, DocumentAssignable ... var2) throws MongoDbException;

    public boolean isCapped() throws MongoDbException;

    public MongoIterator<Document> mapReduce(MapReduce var1) throws MongoDbException;

    public MongoIterator<Document> mapReduce(MapReduce.Builder var1) throws MongoDbException;

    public Collection<MongoIterator<Document>> parallelScan(ParallelScan var1) throws MongoDbException;

    public Collection<MongoIterator<Document>> parallelScan(ParallelScan.Builder var1) throws MongoDbException;

    public int save(DocumentAssignable var1) throws MongoDbException;

    public int save(DocumentAssignable var1, Durability var2) throws MongoDbException;

    public void setDurability(Durability var1);

    public void setReadPreference(ReadPreference var1);

    public BatchedAsyncMongoCollection startBatch();

    public Document stats() throws MongoDbException;

    @Deprecated
    public MongoIterator<TextResult> textSearch(Text var1) throws MongoDbException;

    @Deprecated
    public MongoIterator<TextResult> textSearch(Text.Builder var1) throws MongoDbException;

    public long update(DocumentAssignable var1, DocumentAssignable var2) throws MongoDbException;

    public long update(DocumentAssignable var1, DocumentAssignable var2, boolean var3, boolean var4) throws MongoDbException;

    public long update(DocumentAssignable var1, DocumentAssignable var2, boolean var3, boolean var4, Durability var5) throws MongoDbException;

    public long update(DocumentAssignable var1, DocumentAssignable var2, Durability var3) throws MongoDbException;

    public Document updateOptions(DocumentAssignable var1) throws MongoDbException;

    public Document validate(ValidateMode var1) throws MongoDbException;

    public long write(BatchedWrite var1) throws MongoDbException;

    public long write(BatchedWrite.Builder var1) throws MongoDbException;

    public static enum ValidateMode {
        FULL,
        INDEX_ONLY,
        NORMAL;

    }
}

