/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class MongoDbUri {
    public static final String MONGODB_URI_PREFIX = "mongodb://";
    public static final String MONGODBS_URI_PREFIX = "mongodbs://";
    private final String myDatabase;
    private final List<String> myHosts;
    private final String myOptions;
    private final String myOriginalText;
    private final String myPassword;
    private final String myUserName;
    private final boolean myUseSsl;

    public static boolean isUri(String string) {
        String string2 = string.toLowerCase(Locale.US);
        return string2.startsWith(MONGODB_URI_PREFIX) || string2.startsWith(MONGODBS_URI_PREFIX);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MongoDbUri(String string) throws IllegalArgumentException {
        String string2;
        String string3;
        String string4;
        this.myOriginalText = string;
        boolean bl = false;
        if (string == null) {
            throw new IllegalArgumentException("The MongoDB URI cannot be null.");
        }
        if (string.substring(0, MONGODB_URI_PREFIX.length()).equalsIgnoreCase(MONGODB_URI_PREFIX)) {
            string4 = string.substring(MONGODB_URI_PREFIX.length());
        } else {
            if (!string.substring(0, MONGODBS_URI_PREFIX.length()).equalsIgnoreCase(MONGODBS_URI_PREFIX)) throw new IllegalArgumentException("The MongoDB URI must start with 'mongodb://'.");
            string4 = string.substring(MONGODBS_URI_PREFIX.length());
            bl = true;
        }
        int n = string4.indexOf(64);
        if (n >= 0) {
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 1);
        } else {
            string3 = "";
        }
        n = string4.indexOf(47);
        if (n >= 0) {
            string2 = string4.substring(0, n);
            if ((n = (string4 = string4.substring(n + 1)).indexOf(63)) >= 0) {
                this.myDatabase = string4.substring(0, n);
                this.myOptions = string4.substring(n + 1);
            } else {
                this.myDatabase = string4;
                this.myOptions = "";
            }
        } else {
            this.myDatabase = "";
            n = string4.indexOf(63);
            if (n >= 0) {
                string2 = string4.substring(0, n);
                this.myOptions = string4.substring(n + 1);
            } else {
                string2 = string4;
                this.myOptions = "";
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        this.myHosts = new ArrayList<String>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            this.myHosts.add(stringTokenizer.nextToken());
        }
        if (this.myHosts.isEmpty()) {
            throw new IllegalArgumentException("Must provide at least 1 host to connect to.");
        }
        if (!string3.isEmpty()) {
            n = string3.indexOf(58);
            if (n < 0) throw new IllegalArgumentException("The password for the user '" + string3 + "' must be provided.");
            this.myUserName = string3.substring(0, n);
            this.myPassword = string3.substring(n + 1);
        } else {
            this.myUserName = null;
            this.myPassword = null;
        }
        this.myUseSsl = bl;
    }

    public String getDatabase() {
        return this.myDatabase;
    }

    public List<String> getHosts() {
        return Collections.unmodifiableList(this.myHosts);
    }

    public String getOptions() {
        return this.myOptions;
    }

    public Map<String, String> getParsedOptions() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getOptions(), "?;&");
        while (stringTokenizer.hasMoreTokens()) {
            String string;
            String string2;
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf(61);
            if (n >= 0) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = Boolean.TRUE.toString();
            }
            string2 = string2.toLowerCase(Locale.US);
            linkedHashMap.remove(string2);
            linkedHashMap.put(string2, string);
        }
        return linkedHashMap;
    }

    public String getPassword() {
        return this.myPassword;
    }

    public String getUserName() {
        return this.myUserName;
    }

    public List<String> getValuesFor(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.getOptions(), "?;&");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n = string4.indexOf(61);
            if (n >= 0) {
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            } else {
                string3 = string4;
                string2 = Boolean.TRUE.toString();
            }
            if (!string.equalsIgnoreCase(string3)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public boolean isUseSsl() {
        return this.myUseSsl;
    }

    public String toString() {
        return this.myOriginalText;
    }
}

