/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import java.io.Serializable;

public class ProfilingStatus
implements Comparable<ProfilingStatus>,
Serializable {
    public static final long DEFAULT_SLOW_MS = 100L;
    public static final ProfilingStatus OFF = new ProfilingStatus(Level.NONE);
    public static final ProfilingStatus ON = new ProfilingStatus(Level.ALL);
    private static final long serialVersionUID = 181636899391154872L;
    private final Level myLevel;
    private final long mySlowMillisThreshold;

    public static final ProfilingStatus slow(int n) {
        return new ProfilingStatus(Level.SLOW_ONLY, n);
    }

    private ProfilingStatus(Level level) {
        this(level, 100L);
    }

    private ProfilingStatus(Level level, long l) {
        this.myLevel = level;
        this.mySlowMillisThreshold = l;
    }

    @Override
    public int compareTo(ProfilingStatus profilingStatus) {
        int n = this.myLevel.getValue() - profilingStatus.myLevel.getValue();
        if (n == 0) {
            n = this.mySlowMillisThreshold < profilingStatus.mySlowMillisThreshold ? -1 : (this.mySlowMillisThreshold == profilingStatus.mySlowMillisThreshold ? 0 : 1);
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            ProfilingStatus profilingStatus = (ProfilingStatus)object;
            bl = this.myLevel == profilingStatus.myLevel && this.mySlowMillisThreshold == profilingStatus.mySlowMillisThreshold;
        }
        return bl;
    }

    public Level getLevel() {
        return this.myLevel;
    }

    public long getSlowMillisThreshold() {
        return this.mySlowMillisThreshold;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.myLevel == null ? 0 : this.myLevel.hashCode());
        n = 31 * n + (int)(this.mySlowMillisThreshold ^ this.mySlowMillisThreshold >>> 32);
        return n;
    }

    public String toString() {
        if (this.myLevel == Level.SLOW_ONLY) {
            return this.myLevel.name() + "(" + this.mySlowMillisThreshold + " ms)";
        }
        return this.myLevel.name();
    }

    private Object readResolve() {
        if (this.equals(ON)) {
            return ON;
        }
        if (this.equals(OFF)) {
            return OFF;
        }
        return this;
    }

    public static enum Level {
        ALL(2),
        NONE(0),
        SLOW_ONLY(1);

        private final int myValue;

        public static Level fromValue(int n) {
            for (Level level : Level.values()) {
                if (level.getValue() != n) continue;
                return level;
            }
            return null;
        }

        private Level(int n2) {
            this.myValue = n2;
        }

        public int getValue() {
            return this.myValue;
        }
    }
}

