/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb;

import com.allanbank.mongodb.MongoDbUri;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.impl.RootDocument;
import com.allanbank.mongodb.bson.json.Json;
import com.allanbank.mongodb.error.JsonException;
import com.allanbank.mongodb.util.log.Log;
import com.allanbank.mongodb.util.log.LogFactory;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReadPreferenceEditor
extends PropertyEditorSupport {
    public static final Set<String> MONGODB_URI_FIELDS;
    protected static final Log LOG;
    private static final DocumentAssignable[] EMPTY_TAGS;

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if ("PRIMARY".equalsIgnoreCase(string)) {
            this.setValue(ReadPreference.primary());
        } else if ("SECONDARY".equalsIgnoreCase(string)) {
            this.setValue(ReadPreference.secondary(new DocumentAssignable[0]));
        } else if ("CLOSEST".equalsIgnoreCase(string)) {
            this.setValue(ReadPreference.closest(new DocumentAssignable[0]));
        } else if ("NEAREST".equalsIgnoreCase(string)) {
            this.setValue(ReadPreference.closest(new DocumentAssignable[0]));
        } else if ("PREFER_PRIMARY".equalsIgnoreCase(string)) {
            this.setValue(ReadPreference.preferPrimary(new DocumentAssignable[0]));
        } else if ("PREFER_SECONDARY".equalsIgnoreCase(string)) {
            this.setValue(ReadPreference.preferSecondary(new DocumentAssignable[0]));
        } else if (MongoDbUri.isUri(string)) {
            MongoDbUri mongoDbUri = new MongoDbUri(string);
            ReadPreference readPreference = this.fromUriParameters(mongoDbUri);
            if (readPreference != null) {
                this.setValue(readPreference);
            }
        } else {
            ReadPreference readPreference;
            try {
                readPreference = null;
                Document document = Json.parse(string);
                List<DocumentElement> list = document.find(DocumentElement.class, "tags", ".*");
                DocumentAssignable[] documentAssignableArray = new Document[list.size()];
                for (int i = 0; i < documentAssignableArray.length; ++i) {
                    documentAssignableArray[i] = new RootDocument(list.get(i).getElements());
                }
                Element element = document.get("mode");
                if (element != null) {
                    String string2 = element.getValueAsString();
                    ReadPreference.Mode mode = ReadPreference.Mode.valueOf(string2);
                    switch (mode) {
                        case NEAREST: {
                            readPreference = ReadPreference.closest(documentAssignableArray);
                            break;
                        }
                        case PRIMARY_ONLY: {
                            readPreference = ReadPreference.primary();
                            break;
                        }
                        case PRIMARY_PREFERRED: {
                            readPreference = ReadPreference.preferPrimary(documentAssignableArray);
                            break;
                        }
                        case SECONDARY_ONLY: {
                            readPreference = ReadPreference.secondary(documentAssignableArray);
                            break;
                        }
                        case SECONDARY_PREFERRED: {
                            readPreference = ReadPreference.preferSecondary(documentAssignableArray);
                            break;
                        }
                        case SERVER: {
                            Element element2 = document.get("server");
                            if (element2 == null) break;
                            readPreference = ReadPreference.server(element2.getValueAsString());
                            break;
                        }
                    }
                }
            }
            catch (JsonException jsonException) {
                readPreference = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                readPreference = null;
            }
            if (readPreference != null) {
                this.setValue(readPreference);
            } else {
                throw new IllegalArgumentException("Could not determine the read preferences for '" + string + "'.");
            }
        }
    }

    private ReadPreference fromUriParameters(MongoDbUri mongoDbUri) {
        Map<String, String> map = mongoDbUri.getParsedOptions();
        ReadPreference readPreference = null;
        String string = map.remove("slaveok");
        if (string != null) {
            readPreference = Boolean.parseBoolean(string) ? ReadPreference.SECONDARY : ReadPreference.PRIMARY;
        }
        string = map.remove("readpreference");
        List<String> list = mongoDbUri.getValuesFor("readpreferencetags");
        if (string != null) {
            if ("primary".equalsIgnoreCase(string)) {
                readPreference = ReadPreference.PRIMARY;
            } else if ("primaryPreferred".equalsIgnoreCase(string)) {
                readPreference = ReadPreference.preferPrimary(this.parseTags(list));
            } else if ("secondary".equalsIgnoreCase(string)) {
                readPreference = ReadPreference.secondary(this.parseTags(list));
            } else if ("secondaryPreferred".equalsIgnoreCase(string)) {
                readPreference = ReadPreference.preferSecondary(this.parseTags(list));
            } else if ("nearest".equalsIgnoreCase(string)) {
                readPreference = ReadPreference.closest(this.parseTags(list));
            } else {
                LOG.warn("Unknown readPreference: '{}'. Defaulting to primary.", string);
                readPreference = ReadPreference.PRIMARY;
            }
        }
        return readPreference;
    }

    private DocumentAssignable[] parseTags(List<String> list) {
        if (list == null || list.isEmpty()) {
            return EMPTY_TAGS;
        }
        ArrayList<Document> arrayList = new ArrayList<Document>(list.size());
        for (String string : list) {
            arrayList.add(Json.parse("{" + string + "}"));
        }
        return arrayList.toArray(EMPTY_TAGS);
    }

    static {
        LOG = LogFactory.getLog(ReadPreferenceEditor.class);
        EMPTY_TAGS = new DocumentAssignable[0];
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("readpreferencetags");
        hashSet.add("readpreference");
        hashSet.add("slaveok");
        MONGODB_URI_FIELDS = Collections.unmodifiableSet(hashSet);
    }
}

