/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.bson;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ElementType {
    ARRAY(4),
    BINARY(5),
    BOOLEAN(8),
    DB_POINTER(12),
    DOCUMENT(3),
    DOUBLE(1),
    INTEGER(16),
    JAVA_SCRIPT(13),
    JAVA_SCRIPT_WITH_SCOPE(15),
    LONG(18),
    MAX_KEY(127),
    MIN_KEY(-1),
    MONGO_TIMESTAMP(17),
    NULL(10),
    OBJECT_ID(7),
    REGEX(11),
    STRING(2),
    SYMBOL(14),
    UTC_TIMESTAMP(9);

    private static final Map<ElementType, Integer> ourMongoDbOrdering;
    private final byte myToken;

    public static ElementType valueOf(byte by) {
        switch (by) {
            case 1: {
                return DOUBLE;
            }
            case 2: {
                return STRING;
            }
            case 3: {
                return DOCUMENT;
            }
            case 4: {
                return ARRAY;
            }
            case 5: {
                return BINARY;
            }
            case 7: {
                return OBJECT_ID;
            }
            case 8: {
                return BOOLEAN;
            }
            case 9: {
                return UTC_TIMESTAMP;
            }
            case 10: {
                return NULL;
            }
            case 11: {
                return REGEX;
            }
            case 12: {
                return DB_POINTER;
            }
            case 13: {
                return JAVA_SCRIPT;
            }
            case 14: {
                return SYMBOL;
            }
            case 15: {
                return JAVA_SCRIPT_WITH_SCOPE;
            }
            case 16: {
                return INTEGER;
            }
            case 17: {
                return MONGO_TIMESTAMP;
            }
            case 18: {
                return LONG;
            }
            case 127: {
                return MAX_KEY;
            }
            case -1: {
                return MIN_KEY;
            }
        }
        for (ElementType elementType : ElementType.values()) {
            if (by != elementType.getToken()) continue;
            return elementType;
        }
        return null;
    }

    private ElementType(byte by) {
        this.myToken = by;
    }

    public int compare(ElementType elementType) {
        int n = ourMongoDbOrdering.get((Object)this);
        int n2 = ourMongoDbOrdering.get((Object)elementType);
        return n - n2;
    }

    public byte getToken() {
        return this.myToken;
    }

    static {
        HashMap<ElementType, Integer> hashMap = new HashMap<ElementType, Integer>((int)Math.ceil((double)ElementType.values().length / 0.75));
        int n = 0;
        hashMap.put(MIN_KEY, n);
        hashMap.put(NULL, ++n);
        hashMap.put(DOUBLE, ++n);
        hashMap.put(INTEGER, n);
        hashMap.put(LONG, n);
        hashMap.put(SYMBOL, ++n);
        hashMap.put(STRING, n);
        hashMap.put(DOCUMENT, ++n);
        hashMap.put(ARRAY, ++n);
        hashMap.put(BINARY, ++n);
        hashMap.put(OBJECT_ID, ++n);
        hashMap.put(BOOLEAN, ++n);
        hashMap.put(UTC_TIMESTAMP, ++n);
        hashMap.put(MONGO_TIMESTAMP, n);
        hashMap.put(REGEX, ++n);
        hashMap.put(DB_POINTER, ++n);
        hashMap.put(JAVA_SCRIPT, ++n);
        hashMap.put(JAVA_SCRIPT_WITH_SCOPE, ++n);
        hashMap.put(MAX_KEY, ++n);
        ++n;
        ourMongoDbOrdering = Collections.unmodifiableMap(hashMap);
    }
}

